% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODAchecks.R, R/disco.R
\name{discoODAs}
\alias{discoODAs}
\alias{discoGetODAs}
\title{Execute Oscillation Detection Using DiscoRhythm}
\usage{
discoGetODAs(se, method = NULL, period, circular_t = FALSE)

discoODAs(
  se,
  period = 24,
  method = c("CS", "JTK", "LS", "ARS"),
  circular_t = FALSE,
  ncores = 1
)
}
\arguments{
\item{se}{SummarizedExperiment, the main data object used by DiscoRhythm 
expected to contain se$ID, se$ReplicateID, se$Time sample metadata and
non-null rownames. See the vignette for more details.}

\item{method}{character, short names of ODAs to use. If length>1 
all input method names will be evaluated.}

\item{period}{numeric, the hypothesized period to test for.}

\item{circular_t}{logical, is time circular on some base-cycle
(ex. time of day). See the DiscoRhythm vignette for details.}

\item{ncores}{numeric, number of cores to parallelize with 
(applicable to JTK, ARSER and LS only). If 1, will execute in serial.}
}
\value{
A named list of results where each element is a data.frame for the
corresponding method with rownames corresponding to the feature identifiers
and columns containing estimates for:
\itemize{
  \item acrophase
  \item amplitude
  \item p-value
  \item q-value
}

Additional columns relevant to each method will be present.
}
\description{
Runs specified oscillation detection algorithms (ODAs) 
sequentially to obtain oscillation characteristics for each row of 
the input data.
}
\details{
There are currently 4 available algorithms for rhythm detection:
\itemize{
  \item CS = Cosinor (Cornelissen,G. 2014):  a.k.a “Harmonic Regression” 
  fits a sinusoid with a free phase parameter.
  \item LS = Lomb-Scargle (Glynn, 2006): an approach using spectral power 
  density.
  \item ARS = ARSER (Yang, 2010): removes linear trends and performs the 
  Cosinor test.
  \item JTK = JTK Cycle (Hughes, 2010): non-parametric test of rhythmicity 
  robust to outliers.
}

LS, ARS, and JTK results come directly from MetaCycle meta2d() output using
the specified fixed period. ARSmle is set to "nomle" and no method 
integration is used (see meta2d documentation for details). 

CS is implemented directly in DiscoRhythm's lmCSmat()
as the single-component cosinor described in Cornelissen,G. (2014). 

All q-values are calculated by performing p.adjust() on the resulting 
p-values with method="fdr".

Technical replicates are expected to be merged (likely by discoRepAnalysis) 
prior to usage of discoODAs. 

The discoGetODAs function is called by discoODAs to determine if the selected
methods may be used. If any methods are not valid, a warning will be 
thrown and only valid methods will be computed.
discoGetODAs is not typically used directly, 
however, it may be called by the user to determine
if the provided SummarizedExperiment is suitable for use with the specified
methods.
}
\examples{
# Return valid ODAs for example dataset
discoGetODAs(discoGetSimu(as_se=TRUE),period=24)

# Import the simulated example dataset
se <- discoCheckInput(discoGetSimu(TRUE))

# Use discoRepAnalysis to average technical replicates
se_merged <- discoRepAnalysis(se,aov_pcut=1)$se

# Execute the Cosinor and JTK methods with a 24hr period
discoODAres <- discoODAs(se_merged,method=c("CS","JTK"))

# Get the index of rhythmic features detected by both methods at qvalue<0.05
idx <- which(discoODAres$CS$qvalue<0.05 & discoODAres$JTK$qvalue<0.05)

# Get the identifiers for common rhythmic features
rownames(se_merged)[idx]


}
\references{
Yang R. and  Su Z. (2010). Analyzing circadian expression data by
  harmonic regression based on autoregressive spectral estimation.
  \emph{Bioinformatics}, \bold{26(12)}, i168--i174.

Hughes M. E., Hogenesch J. B. and Kornacker K. (2010). JTK_CYCLE: an
  efficient nonparametric algorithm for detecting rhythmic components in
  genome-scale data sets. \emph{Journal of Biological Rhythms},
  \bold{25(5)}, 372--380.

Glynn E. F., Chen J. and Mushegian A. R. (2006). Detecting periodic
  patterns in unevenly spaced gene expression time series using
  Lomb-Scargle periodograms. \emph{Bioinformatics}, \bold{22(3)},
  310--316.

Cornelissen,G. (2014) Cosinor-based rhythmometry. 
\emph{Theor. Biol. Med. Model.}, \bold{11}, 16.
}
\seealso{
\code{\link{lmCSmat}} \code{\link[MetaCycle]{meta2d}}
}
