% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomGeomArray-class.R
\docType{class}
\name{RandomGeomArray-class}
\alias{RandomGeomArray-class}
\alias{RandomGeomArraySeed-class}
\alias{RandomGeomMatrix-class}
\alias{sampleDistrParam,RandomGeomArraySeed-method}
\alias{sampleDistrFun,RandomGeomArraySeed-method}
\alias{matrixClass,RandomGeomArray-method}
\alias{RandomGeomArraySeed}
\alias{DelayedArray,RandomGeomArraySeed-method}
\alias{RandomGeomArray}
\title{DelayedArray of random geometric-distributed values}
\usage{
RandomGeomArraySeed(dim, prob, chunkdim = NULL, sparse = FALSE)

\S4method{DelayedArray}{RandomGeomArraySeed}(seed)

RandomGeomArray(dim, prob, chunkdim = NULL, sparse = FALSE)
}
\arguments{
\item{dim}{Integer vector of positive length, specifying the dimensions of the array.}

\item{prob}{Numeric vector used as \code{prob} in \code{\link{qgeom}}.
Alternatively, a numeric array-like object with the same dimensions as \code{dim}.}

\item{chunkdim}{Integer vector of length equal to \code{dim}, containing the dimensions of each chunk.}

\item{sparse}{Logical scalar indicating whether the sampled array should be treated as sparse.}

\item{seed}{A RandomGeomArraySeed object.}
}
\value{
All constructors return an instance of a RandomGeomArray object,
containing random draws from a geometric distribution with the specified parameters.
}
\description{
A \linkS4class{DelayedArray} subclass that performs on-the-fly sampling of geometric-distributed values.
}
\examples{
X <- RandomGeomArraySeed(c(1e5, 1e5), prob=0.5)
Y <- DelayedArray(X)
Y

# Fiddling with the distribution parameters:
X2 <- RandomGeomArraySeed(c(1e5, 1e5), prob=runif(1e5, 0, 0.1), sparse=TRUE)
Y2 <- DelayedArray(X2)
Y2

# Using another array as input:
library(Matrix)
prob <- RandomUnifArray(c(1e5, 1e5))
X3 <- RandomGeomArraySeed(c(1e5, 1e5), prob=prob)
Y3 <- DelayedArray(X3)
Y3

}
\seealso{
The \linkS4class{RandomArraySeed} class, for details on chunking and the distributional parameters.
}
\author{
Aaron Lun
}
