% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_deconvo_data.R
\name{fetch_deconvo_data}
\alias{fetch_deconvo_data}
\title{Download Human DLPFC Deconvolution Data}
\usage{
fetch_deconvo_data(
  type = c("rse_gene", "sce", "sce_DLPFC_example"),
  destdir = tempdir(),
  eh = ExperimentHub::ExperimentHub(),
  bfc = BiocFileCache::BiocFileCache()
)
}
\arguments{
\item{type}{A \code{character(1)} specifying which file you want to download.
\itemize{
\item \code{rse_gene}: A \link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment-class}
with 110 bulk RNA-seq samples x 21k genes. (41 MB)
\item \code{sce}: A \link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment}
object with Human DLPFC snRNA-seq data. 77k nuclei x 36k genes (172 MB)
\item \code{sce_DLPFC_example}: An example subset of \code{sec}
\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment}
with 10k nuclei x 557 genes (49 MB)
}}

\item{destdir}{The destination directory to where files will be downloaded
to in case the \code{ExperimentHub} resource is not available. If you already
downloaded the files, you can set this to the current path where the files
were previously downloaded to avoid re-downloading them.}

\item{eh}{An \code{ExperimentHub} object
\link[ExperimentHub:ExperimentHub-class]{ExperimentHub-class}.}

\item{bfc}{A \code{BiocFileCache} object
\link[BiocFileCache:BiocFileCache-class]{BiocFileCache-class}. Used when
\code{eh} is not available.}
}
\value{
The requested object: \code{rse_gene} that you assign to an object
}
\description{
This function downloads the processed data for the experiment documented
at \url{https://github.com/LieberInstitute/Human_DLPFC_Deconvolution}.
Internally, this function downloads the data from \code{ExperimentHub}.
}
\details{
We are currently waiting for \url{https://doi.org/10.1101/2024.02.09.579665} to
pass peer review at a journal, which could lead to changes requested by the
peer reviewers on the processed data for this study. Thus, this function
temporarily downloads the files from Dropbox using
\code{BiocFileCache::bfcrpath()} unless the files are present already at
\code{destdir}.

Note that \code{ExperimentHub} and \code{BiocFileCache} will cache the data and
automatically detect if you have previously downloaded it, thus making it
the preferred way to interact with the data.

This function is based on \code{spatialLIBD::fetch_data()}.
}
\examples{
## Download the bulk RNA gene expression data
## A RangedSummarizedExperiment (41.16 MB)

if (!exists("rse-gene")) rse_gene <- fetch_deconvo_data("rse_gene")

## explore bulk data
rse_gene

## load example snRNA-seq data
## A SingleCellExperiment (4.79 MB)
if (!exists("sce_DLPFC_example")) sce_DLPFC_example <- fetch_deconvo_data("sce_DLPFC_example")

## explore example sce data
sce_DLPFC_example

## check the logcounts
SingleCellExperiment::logcounts(sce_DLPFC_example)[1:5, 1:5]

\donttest{
## download the full sce experiment object
sce_path_zip <- fetch_deconvo_data("sce")
sce_path <- unzip(sce_path_zip, exdir = tempdir())
sce <- HDF5Array::loadHDF5SummarizedExperiment(
    file.path(tempdir(), "sce_DLPFC_annotated")
)
}
}
