% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Normalization_TestSet.R
\name{DaMiR.iTSnorm}
\alias{DaMiR.iTSnorm}
\title{Normalization of Independent Test Set}
\usage{
DaMiR.iTSnorm(
  Learning_set,
  Ind_Test_set,
  normtype = c("vst", "rlog", "logcpm"),
  method = c("precise", "quick")
)
}
\arguments{
\item{Learning_set}{A SummarizedExperiment object or a data frame/matrix
of raw count data. The learning set is supposed to be a raw counts
dataset of the expressed features (not all features).
Rows and Cols should be features and samples, respectively.}

\item{Ind_Test_set}{A SummarizedExperiment object or a data frame/matrix
of raw count data. The independent test set is supposed to be a raw counts
dataset with the same features of 'Learning_set'.
Rows and Cols should be features and samples, respectively.}

\item{normtype}{Type of normalization to be applied:
\code{varianceStabilizingTransformation}
(\code{vst}), \code{rlog} or \code{logcpm} are allowed;
 default is "\code{vst}".}

\item{method}{Type of method to estimate the dispersion, applied to the
independent test set to normalize data. Only 'precise' and 'quick' are
allowed. In the first case, the dispersion is estimated by the Learning
set and applied to the independent test set. In the second case, is
estimated from the independent test set. Default is "precise".
See details in \link{dispersionFunction}}
}
\value{
A matrix containing a normalized expression matrix (log2 scale)
}
\description{
This function aims to normalize properly an actual
independent test set by taking information from the Learning set
that will be used to transform the new sample(s).
}
\details{
The Learning_set is supposed to be a raw counts dataset of the
expressed features. Moreover, the independent test set is supposed
to be a raw counts dataset with the same features of 'Learning_set'.
The independent test set is normalized, taking into account the dispersion
parameter, estimated by the Learning set ('precise' method) or by the
independent test set itself ('quick' method).
}
\examples{
# use example data:
data(SE)

}
\references{
Michael I Love, Wolfgang Huber and Simon Anders (2014):
Moderated estimation of
 fold change and dispersion for RNA-Seq data with DESeq2. Genome Biology
}
\seealso{
\code{\link{varianceStabilizingTransformation}, \link{rlog} \link{cpm}}
}
\author{
Mattia Chiesa, Luca Piacentini
}
