% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sv_identification.R
\name{DaMiR.SV}
\alias{DaMiR.SV}
\title{Identification of Surrogate Variables}
\usage{
DaMiR.SV(
  data,
  method = c("fve", "leek", "be"),
  th.fve = 0.95,
  second.var = NULL
)
}
\arguments{
\item{data}{A SummarizedExpression object}

\item{method}{The method used to identify sv. If missing, the "fve"
method
will be selected. Otherwise the method "leek" or "be" should be choosen}

\item{th.fve}{This argument sets the threshold of maximum fraction of
variance
explained (fve) to be used in conjunction with "fve" method; default is
 0.95}

\item{second.var}{A factor or a numeric vector corresponding to an
additional variable to take into account during the sv identification.
This variable together with 'class' in the data object will be used
to design the model matrix (~ class + second.var)}
}
\value{
A matrix of sv.
A plot with the sv identified by "fve" method is also returned. A red dot shows
 the
 maximum number of variables to be included for a specific "fve".
}
\description{
This function returns a matrix of surrogate variables (sv)
 using the implementation
 by Chiesa-Piacentini or the sva method by Leek et al.
}
\details{
This function helps the user to identify the appropriate number of sv:
it is possible to select a different strategy to be used by changing the
 option in \code{method}
argument. Three methods are available:
 \itemize{
  \item "be" - this option uses the \code{num.sv} function of \code{sva}
   package with default parameters;
  \item "leek" - The same of before but with asymptotic approach proposed
   by Leek;
  \item "fve" - This method is introduced in \code{DaMiRseq} package,
  and integrates part
   of \code{sva} function with custom code. Briefly, we computed
   eigenvalues of \code{data}
   using code already implemented in \code{sva} function and then, we
   calculated the squared
   of each eigenvalues. Thus, the ratio between each "squared eigenvalue"
    and the sum of them
   were calculated. These values represent a surrogate measure of the
   "Percentage of
   Explained Variance" (pve) obtained by principal component analysis (PCA),
    and their cumulative
   sum can be used to select sv.
}
}
\examples{
# use example data:
data(data_norm)
sv <- DaMiR.SV(data_norm, method = "fve", th.fve=0.95)

}
\references{
Jeffrey T. Leek, W. Evan Johnson, Hilary S. Parker, Elana J. Fertig,
 Andrew E.
Jaffe and John D. Storey (2016). sva: Surrogate Variable Analysis. R package
version 3.22.0.
}
\seealso{
\code{\link{sva}}
}
\author{
Mattia Chiesa, Luca Piacentini
}
