% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{DaMiR.Allplot}
\alias{DaMiR.Allplot}
\title{Quality assessment and visualization of expression data}
\usage{
DaMiR.Allplot(
  data,
  df,
  type = c("spearman", "pearson"),
  what = c("all", "all_w_PCA", "MDS", "PCA", "heatmap", "RLEbox", "distr", "avg_distr")
)
}
\arguments{
\item{data}{A SummarizedExperiment object or a matrix or a data.frame
where rows and cols should be, respectively, observations and features}

\item{df}{A data frame with class and known variables (or a subset
of them); at least one column with
'class' label must be included}

\item{type}{A character string specifing the metric to be applied to
 correlation
analysis. Either "spearman" or "pearson" is allowed; default is
"spearman"}

\item{what}{A character string specifing the plots to be shown
'all', 'all_w_PCA', 'MDS','PCA','heatmap','RLEbox', 'distr',
'avg_distr' are allowed; default is "all"}
}
\value{
A dendrogram and heatmap, MDS plot(s), a RLE boxplot, a
sample-by-sample expression value distribution, and a class
average expression value distribution
}
\description{
This is a helper function to easily draw (1) clustering
 dendrogram and heatmap of a sample-per-sample correlation matrix, (2)
multidimensional scaling plots (MDS), (3) relative log expression
 (RLE) boxplots of expression data, (4) a sample-by-sample expression
 value distribution, and (5) a class average expression value
 distribution
}
\details{
Please be sure that NAs are not present in \code{df}'s columns.
Plots will not be drawn in the presence of NAs.
}
\examples{
# use example data:
data(data_norm)
data(df)
# Draw clustering dendrogram and heatmap, MDS, RLE boxplot:
DaMiR.Allplot(data=data_norm, df=df[,5,drop=FALSE])

}
\author{
Mattia Chiesa, Luca Piacentini
}
