% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DO.Correlation.R
\name{DO.Correlation}
\alias{DO.Correlation}
\title{DO Correlation Plot for visualizing similarity between categories}
\usage{
DO.Correlation(
  sce_object,
  group_by = "orig.ident",
  assay = "RNA",
  features = NULL,
  method = "spearman",
  plotdesign = "square",
  plottype = "full",
  auto_limits = TRUE,
  outline.color = "white",
  colormap = c("royalblue4", "lightsteelblue", "tomato", "firebrick4"),
  lab_size = 10,
  lab = TRUE,
  lab_col = "white",
  axis_size_x = 12,
  axis_size_y = 12,
  ...
)
}
\arguments{
\item{sce_object}{Seurat or SCE Object}

\item{group_by}{Column to aggregate the expression over it, default
"orig.ident"}

\item{assay}{Assay in object to use, default "RNA"}

\item{features}{What genes to include by default all, default "None"}

\item{method}{Correlation method, default "spearman"}

\item{plotdesign}{Plot design, default "circle"}

\item{plottype}{Show the full plot or only half of it, default "full"}

\item{auto_limits}{Automatically rescales the colour bar based on the values
in the correlation matrix, default "TRUE"}

\item{outline.color}{the outline color of square or circle. Default value is
"white".}

\item{colormap}{Defines the colormap used in the plot, default
c("royalblue4", "royalblue2","firebrick","firebrick4")}

\item{lab_size}{Size to be used for the correlation coefficient labels. used
when lab = TRUE.}

\item{lab}{logical value. If TRUE, add correlation coefficient on the plot.}

\item{lab_col}{color to be used for the correlation coefficient labels. used
when lab = TRUE.}

\item{axis_size_x}{Controls x labels size}

\item{axis_size_y}{Controls y labels size}

\item{...}{Additionally arguments passed to ggcorrplot function}
}
\value{
ggplot2
}
\description{
Generates a correlation heatmap from expression data to
visualize similarity across sample groups. Allows customization of plot type,
correlation method, and color scaling using the ggcorrplot2 and ggplot2
architectures. Ideal for comparing transcriptional profiles between
conditions or clusters.
}
\examples{
sce_data <-
    readRDS(system.file("extdata", "sce_data.rds", package = "DOtools"))

DO.Correlation(
    sce_object = sce_data,
    group_by = "orig.ident",
    assay = "RNA",
    features = NULL,
    method = "spearman",
    plotdesign = "square",
    plottype = "full",
    auto_limits = TRUE,
    outline.color = "white",
    colormap = c("royalblue4", "lightsteelblue", "tomato", "firebrick4"),
    lab_size = 10,
    lab = TRUE,
    lab_col = "white"
)

}
\author{
Mariano Ruz Jurado
}
