% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/all-methods.R
\name{expressionData}
\alias{expressionData}
\alias{expressionData,DNEA-method}
\title{Access expression data within a DNEA object,}
\usage{
expressionData(x, assay)

\S4method{expressionData}{DNEA}(x, assay = names(assays(x)))
}
\arguments{
\item{x}{A \code{\link{DNEA}} object.}

\item{assay}{A character string corresponding to the
data to retrieve: "input_data" retrieves the data as
it was input, "log_input_data" retrieves the input data
after log transforming, and "log_scaled_data"
retrieves a list of matrices corresponding to the
log-scaled data for each experimental condition,
respectively. Any other externally transformed
data that is stored in the DNEA object can be accessed
by providing its name to the assay parameter.}
}
\value{
The expression matrix specified by the user.
}
\description{
This function accesses the expression data stored in the
assays slot of the \code{\link{DNEA}} object. The
output is an \emph{n x m} matrix with one row for each
sample and one column for each feature in the data.
}
\examples{
#load example data
data(TEDDY)
data(T1Dmeta)

#make sure metadata and expression data are in same order
T1Dmeta <- T1Dmeta[colnames(TEDDY),]

#create group labels
group_labels <- T1Dmeta$group
names(group_labels) <- rownames(T1Dmeta)

#initiate DNEA object
dnw <- createDNEAobject(project_name = "test", expression_data = TEDDY,
                            group_labels = group_labels)

expressionData(x=dnw, assay="input_data")
expressionData(x=dnw, assay="log_input_data")
expressionData(x=dnw, assay="log_scaled_data")
}
\seealso{
\code{\link{createDNEAobject}},\code{\link{aggregateFeatures}}
}
\author{
Christopher Patsalis
}
