% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initiator.R
\name{createDNEAobject}
\alias{createDNEAobject}
\title{Initialize a DNEA object}
\usage{
createDNEAobject(
  project_name,
  expression_data,
  scaled_expression_data,
  group_labels,
  assay
)
}
\arguments{
\item{project_name}{A character string name for the experiment.}

\item{expression_data}{A numeric \emph{m x n} matrix or data frame
of un-transformed, un-scaled expression data. The sample names
should be column names and the feature names should be row names.}

\item{scaled_expression_data}{A list of numeric \emph{m x n}
matrices or data frames of transformed and/or scaled expression
data. The sample names should be column names and the feature
names should be row names. Each set of expression data should
be aproximately normal.}

\item{group_labels}{A factor vector of experimental group labels
named with the corresponding sample name.}

\item{assay}{A character string indicating which assay to use for
diagnostics and differential expression analysis NOTE: The
function always defaults to using log transformed data for
differential expression analysis if provided.}
}
\value{
A \code{\link[=DNEA-class]{DNEA}} object.
}
\description{
This function takes as input a matrix of non-normalized, non-transformed
expression data and the case/control group labels in order to initiate a
DNEA object. Differential expression analysis is performed using a
student's T-test and Benjamini-Hochberg for multiple-testing corrections.
Diagnostic testing is done on the input data by checking the minimum
eigen value and condition number of the expression data for each
experimental condition. To initialize a \emph{DNEA} from a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment-class}},
or a mass_dataset-class from the massdataset package,
please see the \code{\link{sumExp2DNEA}} and
\code{\link{massDataset2DNEA}} documentation, respectively.
\subsection{IMPORTANT:}{

Special attention should be given to the diagnostic criteria that is
output. The minimum eigen value and condition number are calculated for
the whole data set as well as for each condition to determine mathematic
stability of the data set and subsequent results from a GGM model. More
information about interpretation can be found in the
\strong{\emph{Details}} section below.
}
}
\details{
\subsection{Diagnostics Motivation}{

Negative or zero eigenvalues in a data set can represent
instability in that portion of the matrix, thereby invalidating
parametric statistical methods and creating unreliable results. In this
function, the minimum eigenvalue of the data set is calculated by first
creating a pearson correlation matrix of the data. Instability may then
occur for a number of reasons, but one common cause is highly correlated
features (in the positive and negative direction). \cr

Regularization often takes care of this problem by arbitrarily
selecting one of the variables in a highly correlated group and removing
the rest. We have developed DNEA to be very robust in situations where
\strong{\emph{p >> n}} by optimizing the model via several regularization
steps (\emph{please see} \code{\link{BICtune}} \emph{and}
\code{\link{stabilitySelection}}) that may handle such problems without
intervention, however, the user can also pre-emptively collapse
highly-correlated features into a single group via
\code{\link{aggregateFeatures}}.
}

\subsection{Benefits of Feature Aggregation}{

When your dataset contains highly correlated features, we recommend
aggregating features into related groups - such as highly-correlated
features of a given class of molecules (ie. many fatty acids,
carnitines, etc.) - because the user then has more control over which
variables are included in the model. Without collapsing, the model
regularization may result in one of the features within a class being
included and some or all of the remaining features being removed. By
collapsing first, you retain the signal from all of the features in the
collapsed group and also have information pertaining to which features
are highly correlated and will therefore have similar
feature-feature associations.
}
}
\examples{
#import example data
data(TEDDY)
data(T1Dmeta)

#create group labels
group_labels <- factor(T1Dmeta$group,
                       levels=c("DM:control", "DM:case"))
names(group_labels) <- rownames(T1Dmeta)


#initiate DNEA object
DNEA <- createDNEAobject(expression_data=TEDDY,
                         project_name="TEDDYmetabolomics",
                         group_labels=group_labels)
}
\seealso{
\code{\link{BICtune}}, \code{\link{stabilitySelection}},
\code{\link{sumExp2DNEA}}, \code{\link{massDataset2DNEA}}
}
\author{
Christopher Patsalis
}
