% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadData.R
\name{saveBismark}
\alias{saveBismark}
\title{Save Bismark}
\usage{
saveBismark(methylationData, filename)
}
\arguments{
\item{methylationData}{the methylation data stored as a \code{\link{GRanges}}
object with four metadata columns (see \code{\link{methylationDataList}}).}

\item{filename}{the filename where the data will be saved.}
}
\value{
Invisibly returns \code{NULL}
}
\description{
This function takes as input a \code{\link{GRanges}} object generated with
\code{\link{readBismark}} and saves the output to a file using
Bismark CX report format.
}
\examples{

# load methylation data object
data(methylationDataList)

# save one dataset to a file
saveBismark(methylationDataList[["WT"]], "chr3test_a_thaliana_wt.CX_report")

}
\author{
Nicolae Radu Zabet
}
