% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadData.R
\name{readBismark}
\alias{readBismark}
\title{Read Bismark}
\usage{
readBismark(file)
}
\arguments{
\item{file}{The filename (including path) of the methylation
(CX report generated by Bismark) to be read.}
}
\value{
the methylation data stored as a \code{\link{GRanges}}
object with four metadata columns (see \code{\link{methylationDataList}}).
}
\description{
This function takes as input a CX report file produced by Bismark
and returns a \code{\link{GRanges}} object with four metadata columns
The file represents the bisulfite sequencing methylation data.
}
\examples{

# load methylation data object
data(methylationDataList)

# save the one datasets into a file
saveBismark(methylationDataList[["WT"]], "chr3test_a_thaliana_wt.CX_report")

# load the data
methylationDataWT <- readBismark("chr3test_a_thaliana_wt.CX_report")

#check that the loading worked
all(methylationDataWT == methylationDataList[["WT"]])

}
\author{
Nicolae Radu Zabet and Jonathan Michael Foonlan Tsang
}
