% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeDMRs.R
\name{filterDMRs}
\alias{filterDMRs}
\title{Filter DMRs}
\usage{
filterDMRs(
  methylationData1,
  methylationData2,
  potentialDMRs,
  context = "CG",
  test = "fisher",
  pValueThreshold = 0.01,
  minCytosinesCount = 4,
  minProportionDifference = 0.4,
  minReadsPerCytosine = 3,
  parallel = FALSE,
  BPPARAM = NULL,
  cores = NULL
)
}
\arguments{
\item{methylationData1}{the methylation data in condition 1
(see \code{\link{methylationDataList}}).}

\item{methylationData2}{the methylation data in condition 2
(see \code{\link{methylationDataList}}).}

\item{potentialDMRs}{a \code{\link{GRanges}} object with potential DMRs 
where to compute the DMRs. This can be a a list of gene and/or transposable 
elements coordinates.}

\item{context}{the context in which the DMRs are computed (\code{"CG"}, 
\code{"CHG"} or \code{"CHH"}).}

\item{test}{the statistical test used to call DMRs (\code{"fisher"} for 
Fisher's exact test or \code{"score"} for Score test).}

\item{pValueThreshold}{DMRs with p-values (when performing the statistical 
test; see \code{test}) higher or equal than \code{pValueThreshold} are 
discarded. Note that we adjust the p-values using the Benjamini and 
Hochberg's method to control the false discovery rate.}

\item{minCytosinesCount}{DMRs with less cytosines in the specified context 
than \code{minCytosinesCount} will be discarded.}

\item{minProportionDifference}{DMRs where the difference in methylation 
proportion between the two conditions is lower than 
\code{minProportionDifference} are discarded.}

\item{minReadsPerCytosine}{DMRs with the average number of reads lower than 
\code{minReadsPerCytosine} are discarded.}

\item{parallel}{Logical; run in parallel if \code{TRUE}.}

\item{BPPARAM}{A \code{BiocParallelParam} object controlling parallel execution.
This value will automatically set when parallel is \code{TRUE}, also able to set as manually.}

\item{cores}{Integer number of workers (must not exceed BPPARAM$workers).
This value will automatically set as the maximum number of system workers,
also able to set as manually.}
}
\value{
a \code{\link{GRanges}} object with 11 metadata columns that contain 
the DMRs; see \code{\link{computeDMRs}}.
}
\description{
This function verifies whether a set of pottential DMRs (e.g. genes, 
transposons, CpG islands) are differentially methylated or not.
}
\examples{
# load the methylation data
data(methylationDataList)
# load the gene annotation data
data(GEs)

#select the genes
genes <- GEs[which(GEs$type == "gene")]

# the regions where to compute the DMRs
regions <- GRanges(seqnames = Rle("Chr3"), ranges = IRanges(1,1E5))
genes <- genes[overlapsAny(genes, regions)]

# filter genes that are differntially methylated in the two conditions
DMRsGenesCG <- filterDMRs(methylationDataList[["WT"]], 
               methylationDataList[["met1-3"]], potentialDMRs = genes, 
               context = "CG", test = "score", pValueThreshold = 0.01, 
               minCytosinesCount = 4, minProportionDifference = 0.4, 
               minReadsPerCytosine = 3, cores = 1)

}
\seealso{
\code{\link{DMRsNoiseFilterCG}}, \code{\link{computeDMRs}}, 
\code{\link{analyseReadsInsideRegionsForCondition}}  
and \code{\link{mergeDMRsIteratively}}
}
\author{
Nicolae Radu Zabet
}
