% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeVMD.R
\name{computeVMDs}
\alias{computeVMDs}
\title{Compute VMDs}
\usage{
computeVMDs(
  methylationData,
  regions = NULL,
  context = "CG",
  binSize = 100,
  minCytosinesCount = 4,
  sdCutoffMethod = "per.high",
  percentage = 0.05,
  minGap = 200,
  minSize = 50,
  minReadsPerCytosine = 4,
  parallel = FALSE,
  BPPARAM = NULL,
  cores = NULL
)
}
\arguments{
\item{methylationData}{the methylation data in condition
(see \code{\link{ontSampleGRangesList}}).}

\item{regions}{a \code{\link{GRanges}} object with the regions where to 
compute the VMDs. If \code{NULL}, the VMDs are computed genome-wide.}

\item{context}{the context in which the VMDs are computed (\code{"CG"}, 
\code{"CHG"} or \code{"CHH"}).}

\item{binSize}{the size of the tiling bins in nucleotides. This parameter is 
required only if the selected method is \code{"bins"}.}

\item{minCytosinesCount}{VMDs with less cytosines in the specified context 
than \code{minCytosinesCount} will be discarded.}

\item{sdCutoffMethod}{Character string specifying how to determine the cutoff
for filtering VMDs based on their methylation variance (standard deviation).
Available options are:
\describe{
  \item{\code{"per.high"}}{Selects the top \code{percentage} of regions with the highest variance (standard deviation).}
  \item{\code{"per.low"}}{Selects the bottom \code{percentage} of regions with the lowest variance.}
  \item{\code{"EDE.high"}}{Uses the elbow point (inflection/knee) from the descendingly sorted variance values to determine a data-driven high-variance cutoff. Retains regions with SD above this elbow point.}
  \item{\code{"EDE.low"}}{Uses the elbow point from the ascendingly sorted variance values to define a low-variance cutoff. Retains regions with SD below this point.}
}
This allows either quantile-based filtering or automatic detection of variance thresholds based on distribution shape.}

\item{percentage}{Numeric cutoff used when \code{sdCutoffMethod} is set to
\code{"per.high"} or \code{"per.low"}. Represents the quantile threshold:
for example, \code{percentage = 0.05} keeps the top 5\% or bottom 5\% of
bins based on standard deviation, depending on the selected method.}

\item{minGap}{VMDs separated by a gap of at least \code{minGap} are not 
merged. Note that only VMDs where the change in methylation is in the same 
direction are joined.}

\item{minSize}{VMDs with a size smaller than \code{minSize} are discarded.}

\item{minReadsPerCytosine}{VMDs with the average number of reads lower than 
\code{minReadsPerCytosine} are discarded.}

\item{parallel}{Logical; run in parallel if \code{TRUE}.}

\item{BPPARAM}{A \code{BiocParallelParam} object controlling parallel execution.
This value will automatically set when parallel is \code{TRUE}, also able to set as manually.}

\item{cores}{Integer number of workers (must not exceed BPPARAM$workers).
This value will automatically set as the maximum number of system workers,
also able to set as manually.}
}
\value{
the VMDs stored as a \code{\link{GRanges}} object with the following 
metadata columns:
\describe{
 \item{context}{the context in which the VMDs was computed (\code{"CG"}, 
 \code{"CHG"} or \code{"CHH"}).}
 \item{sumReadsM}{the number of methylated reads.}
 \item{sumReadsN}{the total number of reads.} 
 \item{proportion}{the proportion from total methylated reads.} 
 \item{cytosinesCount}{the number of cytosines in the VMDs.}
 \item{mean}{mean value comparing per‐read proportions}
 \item{sd}{standard deviation comparing per‐read proportions}
 \item{w_mean}{weighted mean value comparing per‐read proportions}
 \item{w_sd}{weighted standard deviation comparing per‐read proportions} 
}
}
\description{
This function computes the variance methylated domains between pre-set
min and max proportion values.
}
\examples{
\dontrun{
# load the ONT methylation data 
data(ontSampleGRangesList)

# the regions where to compute the VMDs
chr1_ranges <- GRanges(seqnames = Rle("chr1"), ranges = IRanges(1E6+5E5,1E6+6E5))

# compute the VMDs in CG context with bins method
VMDsBinsCG <- computeVMDs(ontSampleGRangesList[["GM18501"]],
                          regions = NULL,
                          context = "CG",
                          binSize = 100,
                          minCytosinesCount = 4,
                          sdCutoffMethod = "EDE.high",
                          percentage = 0.05,
                          minGap = 200,
                          minSize = 50,
                          minReadsPerCytosine = 4,
                          parallel = FALSE,
                          BPPARAM = NULL,
                          cores = 1)
}
}
\seealso{
\code{\link{readONTbam}}, \code{\link{filterVMDs}}
and \code{\link{analyseReadsInsideRegionsForCondition}}
}
\author{
Nicolae Radu Zabet, Jonathan Michael Foonlan Tsang and Young Jun Kim
}
