% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialCorrelation.R
\name{computeMethylationDataSpatialCorrelation}
\alias{computeMethylationDataSpatialCorrelation}
\title{Compute methylation data spatial correlation}
\usage{
computeMethylationDataSpatialCorrelation(
  methylationData,
  regions = NULL,
  context = "CG",
  distances = NULL
)
}
\arguments{
\item{methylationData}{the methylation data stored as a \code{\link[GenomicRanges]{GRanges}}
object with four metadata columns (see \code{\link{methylationDataList}}).}

\item{regions}{a \code{\link[GenomicRanges]{GRanges}} object with the regions where to
compute the correlation. If \code{NULL}, the correlation is computed
genome-wide.}

\item{context}{the context in which the correlation is computed (\code{"CG"},
\code{"CHG"} or \code{"CHH"}).}

\item{distances}{a \code{numeric} vector specifing the different values for
the distances when computing the correlation.}
}
\value{
a \code{vector} with the correlation of the methylation levels for
Cytosines located at distances specified in the \code{distances}
\code{vector}.
}
\description{
This function computes the correlation of the methylation levels as a
function of the distances between the Cytosines. The function returns a
\code{vector} with the correlation of methylation levels at distance equal to
a \code{vector} of specified thresholds.
}
\examples{


# load the methylation data
data(methylationDataList)

# compute spatial correlation in CG context
distances <- c(1,5,10,15)
correlation_CG_wt <- computeMethylationDataSpatialCorrelation(methylationDataList[["WT"]],
                 context="CG", distances=distances)



}
\seealso{
\code{\link{plotMethylationDataSpatialCorrelation}},
\code{\link{methylationDataList}}
}
\author{
Nicolae Radu Zabet
}
