% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{params}
\alias{params}
\title{params}
\arguments{
\item{methReads}{The matrix \code{methReads} contains the number of
methylated reads spanning a CpG-site. The rows represent the CpG sites in
\code{rowRanges} and the columns represent the samples in \code{colData}.}

\item{totalReads}{The matrix \code{totalReads} contains the number of reads
spanning a CpG-site. The rows represent the CpG sites in \code{rowRanges}
and the columns represent the samples in \code{colData}.}

\item{methLevels}{The matrix \code{methLevels} contains the predicted
methylation level spanning a CpG-site using Hidden Markov model. The rows
represent the CpG sites in \code{rowRanges} and the columns represent the
samples in \code{colData}.}

\item{methVars}{The matrix \code{methVars} contains the variances of the
corresponding \code{methLevels} obtianed from MCMC.}

\item{methStates}{The matrix \code{methStates} contains the state of
methylation obtained from Hidden Markov model spanning a CpG-site. The rows
represent the CpG sites in \code{rowRanges} and the columns represent the
samples in \code{colData}. The value of state is stored in \code{metadata},
named \code{Beta}.}

\item{rowRanges}{A \code{\link{GRanges}} or \code{\link{GRangesList}}
object describing the ranges of interest. Names, if present, become the row
names of the \code{\link{SummarizedExperiment}} object. The length of the
\code{\link{GRanges}} or \code{\link{GRangesList}} must equal the number of
rows of the matrices in \code{assays}. If \code{rowRanges} is missing, a
\code{\link{SummarizedExperiment}} instance is returned.}

\item{colData}{Object of class \code{"DataFrame"} containing information on
variable values of the samples}

\item{metadata}{An optional \code{list} of arbitrary content describing the
overall experiment}

\item{object}{A \code{\link{BSData-class}} or \code{\link{BSDMCs-class}}
object}

\item{value}{An integer matrix}

\item{obj1}{A \code{\link{BSData-class}} or \code{\link{BSDMCs-class}}}

\item{obj2}{A \code{\link{BSData-class}} or \code{\link{BSDMCs-class}}}

\item{files}{A character list}

\item{file}{A character}

\item{name}{A character list}

\item{MaxK}{An integer value}

\item{MaxEmiter}{An integer value}

\item{epsEM}{A positive numeric value}

\item{useweight}{A logical value}

\item{mc.cores}{An integer greater than 0}

\item{nburn}{An integer value}

\item{nthin}{An integer value}

\item{nsamp}{An integer value}

\item{formula}{A formula}

\item{FDRthreshold}{A numeric value}

\item{Methylthreshold}{A positive numeric value; the default is 0.001}

\item{weightfunction}{A function to create weights using variance obtained
form the MCMC algorithm}

\item{...}{other possible parameters}

\item{col}{A character vector indicating which colors to alternate.}

\item{chrlabs}{A character vector equal to the number of chromosomes
specifying the chromosome labels (e.g., \code{c(1:22, "X", "Y", "MT")}).}

\item{suggestiveline}{Where to draw a "suggestive" line. Default
-log10(1e-5). Set to FALSE to disable.}

\item{genomewideline}{Where to draw a "genome-wide sigificant" line. Default
-log10(5e-8). Set to FALSE to disable.}

\item{highlight}{A character vector of SNPs in your dataset to highlight.
These SNPs should all be in your dataset.}

\item{logp}{If TRUE, the -log10 of the p-value is plotted. It isn't very
useful to plot raw p-values, but plotting the raw value could be useful for
other genome-wide plots, for example, peak heights, bayes factors, test
statistics, other "scores," etc.}

\item{annotatePval}{If set, SNPs below this p-value will be annotated on the
plot.}

\item{annotateTop}{If TRUE, only annotates the top hit on each chromosome
that is below the annotatePval threshold.}

\item{windowsize}{An integer value for partitioning data into windows of size
windowsize.}
}
\description{
parameters name and their descriptions
}
\author{
Farhad Shokoohi <shokoohi@icloud.com>
}
