% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/findDMCFB-method.R
\name{findDMCFB-method}
\alias{findDMCFB-method}
\alias{findDMCFB,BSDMC-method}
\alias{findDMCFB}
\title{findDMCFB method}
\usage{
findDMCFB(
  object,
  bwa,
  bwb,
  nBurn,
  nMC,
  nThin,
  alpha,
  sdv,
  nCores,
  pSize,
  sfiles
)

\S4method{findDMCFB}{BSDMC}(
  object,
  bwa,
  bwb,
  nBurn,
  nMC,
  nThin,
  alpha,
  sdv,
  nCores,
  pSize,
  sfiles
)
}
\arguments{
\item{object}{A \code{\link{BSDMC-class}}
object}

\item{bwa}{An integer value specifying the band-width size of B-spline basis
matrix for a natural cubic spline for the group-specific effects of the
Bayesian functional regression model}

\item{bwb}{An integer value specifying the band-width size of B-spline basis
matrix for a natural cubic spline for the individual-specific effects of the
Bayesian functional regression model}

\item{nBurn}{An integer value specifying the number of burn-in samples}

\item{nMC}{An integer value specifying the number of MCMC samples after
burn-in}

\item{nThin}{An integer value specifying the thining number in MCMC}

\item{alpha}{A numeric value specifying the level of \eqn{\alpha} in credible
interval \eqn{(1-\alpha)\%}}

\item{sdv}{An double value specifying the standard deviation of priors}

\item{nCores}{An integer value specifying the number of machine cores for
parallel computing}

\item{pSize}{An integer value specifying the number of cytosines in a regrion
to be used in a Bayesian functiona regression model for DMC detection}

\item{sfiles}{A logical value indicating whether files to be saved or not.}
}
\value{
\code{\link{BSDMC-class}} object
}
\description{
DMC identification via Bayesian functional regression models
}
\examples{
set.seed(1980)
nr <- 1000
nc <- 4
metht <- matrix(as.integer(runif(nr * nc, 0, 100)), nr)
methc <- matrix(rbinom(n = nr * nc, c(metht), prob = runif(nr * nc)), nr, nc)
methl <- methc / metht
r1 <- GRanges(rep("chr1", nr), IRanges(1:nr, width = 1), strand = "*")
names(r1) <- 1:nr
cd1 <- DataFrame(
  Group = rep(c("G1", "G2"), each = nc / 2),
  row.names = LETTERS[1:nc]
)
OBJ1 <- cBSDMC(
  rowRanges = r1, methReads = methc, totalReads = metht,
  methLevels = methl, colData = cd1
)
OBJ2 <- findDMCFB(OBJ1,
  bwa = 10, bwb = 10, nBurn = 50, nMC = 50, nThin = 1,
  alpha = 0.05, nCores = 2, pSize = 500, sfiles = FALSE
)
OBJ2
}
\author{
Farhad Shokoohi <shokoohi@icloud.com>
}
