% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr.R
\name{format.DataFrame}
\alias{format.DataFrame}
\title{Encode in a Common Format}
\usage{
\method{format}{DataFrame}(x, ...)
}
\arguments{
\item{x}{any \R object (conceptually); typically numeric.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An object of similar structure to \code{x} containing character
  representations of the elements of the first argument \code{x}
  in a common format, and in the current locale's encoding.

  For character, numeric, complex or factor \code{x}, dims and dimnames
  are preserved on matrices/arrays and names on vectors: no other
  attributes are copied.

  If \code{x} is a list, the result is a character vector obtained by
  applying \code{format.default(x, \dots)} to each element of the list
  (after \code{\link[base]{unlist}}ing elements which are themselves lists),
  and then collapsing the result for each element with
  \code{paste(collapse = ", ")}.  The defaults in this case are
  \code{trim = TRUE, justify = "none"} since one does not usually want
  alignment in the collapsed strings.
}
\description{
Format an \R object for pretty printing.
}
\details{
\code{format} is a generic function.  Apart from the methods described
  here there are methods for dates (see \code{\link[base]{format.Date}}),
  date-times (see \code{\link[base]{format.POSIXct}}) and for other classes such
  as \code{format.octmode} and \code{format.dist}.

  \code{format.data.frame} formats the data frame column by column,
  applying the appropriate method of \code{format} for each column.
  Methods for columns are often similar to \code{as.character} but offer
  more control.  Matrix and data-frame columns will be converted to
  separate columns in the result, and character columns (normally all)
  will be given class \code{"\link[base]{AsIs}"}.

  \code{format.factor} converts the factor to a character vector and
  then calls the default method (and so \code{justify} applies).

  \code{format.AsIs} deals with columns of complicated objects that
  have been extracted from a data frame.  Character objects and (atomic)
  matrices are passed to the default method (and so \code{width} does
  not apply).
  Otherwise it calls \code{\link[base]{toString}} to convert the object
  to character (if a vector or list, element by element) and then
  right-justifies the result.

  Justification for character vectors (and objects converted to
  character vectors by their methods) is done on display width (see
  \code{\link[base]{nchar}}), taking double-width characters and the rendering
  of special characters (as escape sequences, including escaping
  backslash but not double quote: see \code{\link[base]{print.default}}) into
  account.  Thus the width is as displayed by \code{print(quote =
  FALSE)} and not as displayed by \code{\link[base]{cat}}.  Character strings
  are padded with blanks to the display width of the widest.  (If
  \code{na.encode = FALSE} missing character strings are not included in
  the width computations and are not encoded.)

  Numeric vectors are encoded with the minimum number of decimal places
  needed to display all the elements to at least the \code{digits}
  significant digits.  However, if all the elements then have trailing
  zeroes, the number of decimal places is reduced until at least one
  element has a non-zero final digit; see also the argument
  documentation for \code{big.*}, \code{small.*} etc, above.  See the
  note in \code{\link[base]{print.default}} about \code{digits >= 16}.

  Raw vectors are converted to their 2-digit hexadecimal representation
  by \code{\link[base]{as.character}}.

  \code{format.default(x)} now provides a \dQuote{minimal} string when
  \code{\link[base]{isS4}(x)} is true.

  While the internal code respects the option
  \code{\link[base]{getOption}("OutDec")} for the \sQuote{decimal mark} in general,
  \code{decimal.mark} takes precedence over that option.  Similarly,
  \code{scientific} takes precedence over \code{\link[base]{getOption}("scipen")}.
}
\examples{
format(1:10)
format(1:10, trim = TRUE)

zz <- data.frame("(row names)"= c("aaaaa", "b"), check.names = FALSE)
format(zz)
format(zz, justify = "left")

## use of nsmall
format(13.7)
format(13.7, nsmall = 3)
format(c(6.0, 13.1), digits = 2)
format(c(6.0, 13.1), digits = 2, nsmall = 1)

## use of scientific
format(2^31-1)
format(2^31-1, scientific = TRUE)
## scientific = numeric scipen (= {sci}entific notation {pen}alty) :
x <- c(1e5, 1000, 10, 0.1, .001, .123)
t(sapply(setNames(,-4:1),
         \\(sci) sapply(x, format, scientific=sci)))


## a list
z <- list(a = letters[1:3], b = (-pi+0i)^((-2:2)/2), c = c(1,10,100,1000),
          d = c("a", "longer", "character", "string"),
          q = quote( a + b ), e = expression(1+x))
## can you find the "2" small differences?
(f1 <- format(z, digits = 2))
(f2 <- format(z, digits = 2, justify = "left", trim = FALSE))
f1 == f2 ## 2 FALSE, 4 TRUE

## A "minimal" format() for S4 objects without their own format() method:
cc <- methods::getClassDef("standardGeneric")
format(cc) ## "<S4 class ......>"
}
\references{
Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988)
  \emph{The New S Language}.
  Wadsworth & Brooks/Cole.
}
\seealso{
\code{\link[base]{format.info}} indicates how an atomic vector would be
  formatted.

  \code{\link[base]{formatC}}, \code{\link[base]{paste}}, \code{\link[base]{as.character}},
  \code{\link[base]{sprintf}}, \code{\link[base]{print}}, \code{\link[base]{prettyNum}},
  \code{\link[base]{toString}}, \code{\link[base]{encodeString}}.
}
