% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{saveGRangesAsTsv}
\alias{saveGRangesAsTsv}
\title{saveGRangesAsTsv}
\usage{
saveGRangesAsTsv(
  GRanges,
  filepath = tempdir(),
  filename = tempfile(),
  col.names = NA,
  row.names = TRUE,
  sep = "\\t",
  force = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{GRanges}{the GRanges object.}

\item{filepath}{the path to store the files.}

\item{filename}{the name to give to the files.}

\item{col.names}{a logical value indicating whether the column names are to be
written in the file, or a character vector indicating the column names, or
NA for writing column names for writing a TAB for the column name of the
row names, default is NA (see \link[utils]{write.table}).}

\item{row.names}{a logical value indicating whether the row names are to be
written in the file, or a character vector indicating the row names
(see \link[utils]{write.table}).}

\item{sep}{the column separator character (default is \code{"\t"}).}

\item{force}{force overwriting.}

\item{verbose}{verbose output flag.}
}
\value{
none
}
\description{
save a GRanges object as tsv file.
}
\examples{
gr <- GRanges(
        seqnames=Rle(c("chr1", "chr2", "chr1", "chr3"), c(1, 3, 2, 4)),
        ranges=IRanges(1:10, end=10),
        strand=Rle(strand(c("-", "+", "*", "+", "-")), c(1, 2, 2, 3, 2)),
        seqlengths=c(chr1=11, chr2=12, chr3=13))
saveGRangesAsTsv(gr, verbose=TRUE)
}
