% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{fromSamplesToChrsGRangesList}
\alias{fromSamplesToChrsGRangesList}
\title{fromSamplesToChrsGRangesList}
\usage{
fromSamplesToChrsGRangesList(samplesGRangesList)
}
\arguments{
\item{samplesGRangesList}{a GRangesList of samples.
Tipically generaed by findPeaks function.}
}
\value{
A GRangesList of chromosomes where each element is a GRanges list
of samples.
}
\description{
converts a GRangesList orgnized per samples to a GRangesList
organized per Chromosomes where each element is a GRangesList of samples.
}
\examples{
library("GenomicRanges")
gr1 <- GRanges(
            seqnames=Rle(c("chr1", "chr2", "chr1", "chr3"), c(1, 3, 2, 4)),
            ranges=IRanges(1:10, end=10),
            strand=Rle(strand(c("-", "+", "*", "+", "-")), c(1, 2, 2, 3, 2)),
            seqlengths=c(chr1=11, chr2=12, chr3=13))
gr2 <- GRanges(
            seqnames=Rle(c("chr1", "chr4", "chr1", "chr3"), c(1, 3, 2, 4)),
            ranges=IRanges(1:10, end=10),
            strand=Rle(strand(c("-", "+", "*", "+", "-")), c(1, 2, 2, 3, 2)),
            seqlengths=c(chr1=11, chr4=12, chr3=13))
sgrl <- GRangesList(gr1, gr2)
names(sgrl) <- c("samp1", "samp2")
(chrGrlSampGr <- fromSamplesToChrsGRangesList(sgrl))
}
