% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakCallFunctions.R
\name{findPeaks}
\alias{findPeaks}
\title{findPeaks}
\usage{
findPeaks(
  files,
  filetype = c("bam", "bed"),
  genomeName = NULL,
  binSize = 50,
  minWin = 50,
  maxWin = 1000,
  zthresh = 10,
  minCount = 0.1,
  minCompWinWidth = 5000,
  maxCompWinWidth = 10000,
  outputFolder = "Peaks",
  save = TRUE,
  force = TRUE,
  verbose = FALSE,
  sigwin = 10,
  onlyStdChrs = TRUE,
  chr = NULL,
  BPPARAM = BiocParallel::bpparam()
)
}
\arguments{
\item{files}{Character vector containing paths of files to be analyzed.}

\item{filetype}{Character, either "bam" or "bed" indicating format of input
file.}

\item{genomeName}{the code of the genome to use as reference for the input
files. (cfr. constructBedRanges function parameters)}

\item{binSize}{Integer size in bases of the minimum window for scanning,
50 is the default.}

\item{minWin}{Integer indicating the minimum window size in bases notation.}

\item{maxWin}{Integer indicating the maximum window size in bases notation.}

\item{zthresh}{Cuttoff value for z-scores. Only windows with greater z-scores
will be kept, default is 10.}

\item{minCount}{A small constant (usually no larger than one) to be added to
the counts prior to the log transformation to avoid problems with log(0).}

\item{minCompWinWidth}{minimum bases width of a comparing window for Z-score.}

\item{maxCompWinWidth}{maximum bases width of a comparing window for Z-score.}

\item{outputFolder}{A string, Name of the folder to save the Peaks (optional)
if the directory doesn't exist, it will be created. (Default is "Peaks")}

\item{save}{Boolean, if TRUE files will be saved in a "./Peaks/chr*"
directory created (if not already present) in the current working directory.}

\item{force}{a boolean flag indicating if to force output overwriting.}

\item{verbose}{if to show additional messages}

\item{sigwin}{an integer value used to compute the length of the signal
of a peak (default value is 10).}

\item{onlyStdChrs}{a flag to work only with standard chromosomes.
(cfr. constructBedRanges function parameters).}

\item{chr}{if not NULL, a character like "chr#" indicating the chromosomes
to use.}

\item{BPPARAM}{object of class \code{bpparamClass} that specifies the
back-end to be used for computations. See
\code{\link[BiocParallel]{bpparam}} for details.}
}
\value{
A GRangesList where each element is a sample.
Each GRanges represents the founded peaks and attached the z-score of
the peak as mcols.
}
\description{
This function calls peaks from bed or bam inputs using a
variable window scan with a poisson model using the surrounding
maxCompWinWidth (10kb) as background.
}
\examples{
bam.files <- list.files(system.file("extdata/bam", package = "DEScan2"),
                        full.names = TRUE)

peaks <- findPeaks(files=bam.files[1], filetype="bam",
                        genomeName="mm9",
                        binSize=50, minWin=50, maxWin=1000,
                        zthresh=5, minCount=0.1, sigwin=10,
                        minCompWinWidth=5000, maxCompWinWidth=10000,
                        save=FALSE,
                        onlyStdChrs=TRUE,
                        chr=NULL,
                        verbose=FALSE)
head(peaks)
}
