% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finalRegionFunctions.R
\name{finalRegions}
\alias{finalRegions}
\title{finalRegions}
\usage{
finalRegions(
  peakSamplesGRangesList,
  zThreshold = 20,
  minCarriers = 2,
  saveFlag = TRUE,
  outputFolder = "overlappedPeaks",
  verbose = FALSE,
  scorecolname = "z-score",
  coverageFlag = FALSE,
  BPPARAM = BiocParallel::bpparam()
)
}
\arguments{
\item{peakSamplesGRangesList}{named GRangesList where each element is a
sample of called peaks. A score mcols values is needed for each GRanges.
The scorecolname param can be used as reference name for the score.
(tipically returned by findPeaks function).}

\item{zThreshold}{a minimum threshold for the z score.
All peaks lesser than this value will be ignored.}

\item{minCarriers}{a threshold of minimum samples (carriers) for overlapped
regions.}

\item{saveFlag}{a flag for saving results in a tsv file.}

\item{outputFolder}{the directory name to store the bed file.}

\item{verbose}{verbose output.}

\item{scorecolname}{character describing the name of the column within the
peaks score.}

\item{coverageFlag}{boolean indicating if to compute the scores in a coverage
mode (sum of the reads of merged peak) or in a score mode
(a normalized score across the merged peaks)}

\item{BPPARAM}{object of class \code{bpparamClass} that specifies the
back-end to be used for computations. See
\code{\link[BiocParallel]{bpparam}} for details.}
}
\value{
a GRanges of selected overlapping peaks with z-score,
n-peaks, k-carriers as mcols object.
}
\description{
Align peaks to form common regions then filter regions for
presence in multiple replicates taking in input a GRangesList where each
element is a sample of called peaks.
}
\examples{
peak.path <- system.file("extdata/peaks/RData/peaksGRL_all_files.rds",
                            package="DEScan2")
grl <- readRDS(peak.path)
grl

regionsGR <- finalRegions(peakSamplesGRangesList=grl, zThreshold=1,
                        minCarriers=3, saveFlag=FALSE, verbose=TRUE)
}
