% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{createGranges}
\alias{createGranges}
\title{createGranges}
\usage{
createGranges(chrSeqInfo, starts, widths, mcolname = NULL, mcolvalues = NULL)
}
\arguments{
\item{chrSeqInfo}{a seqinfo object.}

\item{starts}{the start ranges.}

\item{widths}{the width of each range.}

\item{mcolname}{the name for the mcol attribute.}

\item{mcolvalues}{the values for the mcol attribute.}
}
\value{
a GRanges object.
}
\description{
a simplified wrapper function to create a GRanges object.
}
\examples{
chrSeqInfo <- Seqinfo::Seqinfo(genome="mm9")["chr1"]
starts=sample(seq_len(100), 10)
widths=starts+10;
mcolname <- "z-score";
mcolvalues <- sample(seq_len(100), 10)
chrGR <- createGranges(chrSeqInfo=chrSeqInfo, starts=starts, widths=widths,
              mcolname=mcolname, mcolvalues=mcolvalues)
}
