% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countMatrixFunctions.R
\name{countFinalRegions}
\alias{countFinalRegions}
\title{countFinalRegions}
\usage{
countFinalRegions(
  regionsGRanges,
  readsFilePath = NULL,
  fileType = c("bam", "bed"),
  minCarriers = 2,
  genomeName = NULL,
  onlyStdChrs = FALSE,
  carrierscolname = "k-carriers",
  ignStrandSO = TRUE,
  modeSO = "Union",
  saveFlag = FALSE,
  savePath = "finalRegions",
  verbose = TRUE
)
}
\arguments{
\item{regionsGRanges}{a GRanges objects representing the peaks to compute
the coverage, with a "k-carriers" mcols.
(tipically generated by finalRegions function).}

\item{readsFilePath}{the filepath of bam or bed files necessary to compute
the coverage.}

\item{fileType}{the file type of the input files.}

\item{minCarriers}{minimum number of carriers (samples).}

\item{genomeName}{code name of the genome of reads files (i.e. "mm9").}

\item{onlyStdChrs}{a flag indicating if to keep only the standard chromosomes}

\item{carrierscolname}{character describing the name of the column within the
carriers number (default is "k-carriers").}

\item{ignStrandSO}{a flag indicating if to ignore the reads strand.
(see GenomicAlignments::summarizeOverlaps).}

\item{modeSO}{the mode to use, default is "Union".
(see GenomicAlignments::summarizeOverlaps).}

\item{saveFlag}{a flag indicating if to save the results.}

\item{savePath}{the path where to store the results.}

\item{verbose}{verbose output.}
}
\value{
A SummarizedExperiment object containing as assays the read counts
matrix with regions as rows and samples as columns, and as rowRanges
the GRanges object representing the peaks used as rows in the matrix.
}
\description{
count reads falling within the final regions.
}
\examples{
filename <- system.file("extdata/regions/regions.rds", package="DEScan2")
regionsGR <- readRDS(file=filename)
reads.path <- system.file("extdata/bam", package="DEScan2")
finalRegionsSE <- countFinalRegions(regionsGRanges=regionsGR,
    readsFilePath=reads.path, fileType="bam", minCarriers=1,
    genomeName="mm9", onlyStdChrs=TRUE, ignStrandSO=TRUE, saveFlag=FALSE,
    verbose=TRUE)
library("SummarizedExperiment")
assay(finalRegionsSE) ## matrix of counts
rowRanges(finalRegionsSE) ## the GRanges of the input regions
}
