% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{constructBedRanges}
\alias{constructBedRanges}
\title{constructBedRanges}
\usage{
constructBedRanges(
  filename,
  filetype = c("bam", "bed", "bed.zip", "narrow", "broad"),
  genomeName = NULL,
  onlyStdChrs = FALSE,
  arePeaks = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{filename}{the complete file path of a bam?bed file.}

\item{filetype}{the file type bam/bed/bed.zip/narrow/broad.}

\item{genomeName}{the name of the genome used to map the reads (i.e. "mm9").
N.B. if NOT NULL the GRanges Seqinfo will be forced to genomeName Seqinfo
(needs Internet access, but strongly suggested!)}

\item{onlyStdChrs}{flag to keep only standard chromosome.}

\item{arePeaks}{flag indicating if the file contains peaks.}

\item{verbose}{flag to obtain verbose output.}
}
\value{
a GRanges object.
}
\description{
Constructs a GRanges object from a bam/bed/bed.zip file in a
consistent way.
}
\examples{
files <- list.files(system.file("extdata/bam/", package="DEScan2"),
                    pattern="bam$", full.names=TRUE)
bgr <- constructBedRanges(files[1], filetype="bam", genomeName="mm9",
                            onlyStdChrs=TRUE)
bgr
}
