% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakCallFunctions.R
\name{binnedCoverage}
\alias{binnedCoverage}
\title{binnedCoverage}
\usage{
binnedCoverage(
  bins,
  numvar,
  mcolname,
  covMethod = c("max", "mean", "sum", "min"),
  roundingMethod = c("none", "floor", "ceiling", "round")
)
}
\arguments{
\item{bins}{a GRanges object representing a chromosome binned.}

\item{numvar}{an RleList representing the per base coverage over the chr.}

\item{mcolname}{the name of column where the sum have to be stored.}

\item{covMethod}{a method to apply for the computing of the coverate
it can be one of "max", "mean", "sum", "min". ("max" is default)}

\item{roundingMethod}{a method to apply to round the computations
it can be one of "none", "floor", "ceiling", "round".
It's useful only when using covMethod="mean". ("none" is default)}
}
\value{
the bins GRanges with the mcolname attached
}
\description{
this function computes the coverage over a binned
chromosome, starting from a per base computed coverage.
}
\examples{
## dividing one chromosome in bins of 50 bp each
seqinfo <- Seqinfo::Seqinfo(genome="mm9")
bins <- GenomicRanges::tileGenome(
            seqlengths=Seqinfo::seqlengths(seqinfo)[1],
            tilewidth=50,
            cut.last.tile.in.chrom=TRUE)
gr <- GenomicRanges::GRanges(seqnames = S4Vectors::Rle("chr1", 100),
            ranges=IRanges::IRanges(start = seq(from=10, to=1000, by=10),
            end=seq(from=20, to=1010, by = 10)))
cov <- GenomicRanges::coverage(x=gr)
(binnedMaxCovGR <- binnedCoverage(bins, cov, "binned_cov"))
(binnedMeanCovGR <- binnedCoverage(bins, cov, "binned_cov",
                                covMethod="mean", roundingMethod="floor"))
(binnedSumCovGR <- binnedCoverage(bins, cov, "binned_cov", covMethod="sum"))
}
