% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{se2msn}
\alias{se2msn}
\title{Deprecated Function to coerce SummarizedExperiment to MSnSet object}
\usage{
se2msn(se)
}
\arguments{
\item{se}{SummarizedExperiment,
Object which will be turned into a MSnSet object.}
}
\value{
A MSnSet object.
}
\description{
Use \code{\link[methods]{as}} instead.
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
exp_design <- UbiLength_ExpDesign
se <- make_se(data_unique, columns, exp_design)

# Convert to MSnSet
data_msn <- as(se, "MSnSet")
# Convert back to SE
se_back <- as(data_msn, "SummarizedExperiment")
}
