% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{make_se}
\alias{make_se}
\title{Data.frame to SummarizedExperiment object
conversion using an experimental design}
\usage{
make_se(proteins_unique, columns, expdesign)
}
\arguments{
\item{proteins_unique}{Data.frame,
Protein table with unique names annotated in the 'name' column
(output from \code{\link{make_unique}()}).}

\item{columns}{Integer vector,
Column numbers indicating the columns containing the assay data.}

\item{expdesign}{Data.frame,
Experimental design with 'label', 'condition'
and 'replicate' information.
See \code{\link{UbiLength_ExpDesign}} for an example experimental design.}
}
\value{
A SummarizedExperiment object
with log2-transformed values.
}
\description{
\code{make_se} creates a SummarizedExperiment object
based on two data.frames: the protein table and experimental design.
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
exp_design <- UbiLength_ExpDesign
se <- make_se(data_unique, columns, exp_design)
}
