% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\name{DGEList}
\alias{DGEList}
\alias{DGEList,RangedSummarizedExperiment-method}
\title{DGEList Constructor Generic}
\usage{
DGEList(counts, ...)

\S4method{DGEList}{RangedSummarizedExperiment}(
  counts = new("RangedSummarizedExperiment"),
  lib.size = colData(counts)$lib.size,
  norm.factors = colData(counts)$norm.factors,
  samples = colData(counts),
  group = NULL,
  genes = as.data.frame(rowRanges(counts)),
  remove.zeros = FALSE
)
}
\arguments{
\item{counts}{read counts, either a numeric matrix or a
\linkS4class{RangedSummarizedExperiment} object.}

\item{...}{other arguments are not currently used.}

\item{lib.size}{numeric vector of library sizes (sequencing depths) for the samples. Defaults to \code{colSums(counts)}.}

\item{norm.factors}{numeric vector of normalization factors that modify the library sizes. Defaults to a vector of ones.}

\item{samples}{data.frame containing sample information, with a row for each sample. This data.frame will be appended to the \code{samples} component of the DGEList object.}

\item{group}{vector or factor giving the experimental group or treatment condition for each sample. Defaults to a single group.}

\item{genes}{data.frame containing gene annotation.}

\item{remove.zeros}{logical, whether to remove rows that have 0 total count.}
}
\value{
A \linkS4class{DGEList} object.
}
\description{
Creates a \linkS4class{DGEList} object.
}
\examples{
se = simulateRnaSeqData(output = "RangedSummarizedExperiment")

## Initialize a DGEList from a RangedSummarizedExperiment object
DGEList(se)
}
\author{
Andrzej Oleś <\email{andrzej.oles@gmail.com}>, 2016-2023
}
