% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcats_GLM.R
\name{dcats_GLM}
\alias{dcats_GLM}
\title{A Generalised linear model based likelihood ratio testing}
\usage{
dcats_GLM(
  count_mat,
  design_mat,
  similarity_mat = NULL,
  pseudo_count = NULL,
  base_model = "NULL",
  fix_phi = NULL,
  reference = NULL
)
}
\arguments{
\item{count_mat}{A matrix of composition sizes (n_sample, n_cluster) for each
cluster in each sample}

\item{design_mat}{A matrix or a data frame of testing candidate factors 
(n_sample, n_factor) with same sample order as count_mat. All factors 
should be continous and categorical with only two levels.}

\item{similarity_mat}{A matrix of floats (n_cluster, n_cluster) for the
similarity matrix between cluster group pair. The order of cluster should
be consistent with those in `count_mat`.}

\item{pseudo_count}{A pseudo count to add for counts in all cell types
Default NULL means 0 except if a cell type is empty in one condition,
otherwise pseudo_count will be: 0.01 * rowMeans for each condition}

\item{base_model}{A string value: `NULL` for 1 factor vs NULL factor testing;
`FULL` for FULL factors vs n-1 factors testing.}

\item{fix_phi}{A numeric used to provided a fixed phi value for the GLM 
for all cell types}

\item{reference}{A vector of characters indicating which cell types are used 
as reference for normalization. `NULL` indicates using total count for 
normalization.}
}
\value{
a list of significance p values for each cluster
}
\description{
GLM supports both beta-binomial and negative binomial from aod package.
}
\examples{
K <- 3
totals1 = c(100, 800, 1300, 600)
totals2 = c(250, 700, 1100)
diri_s1 = rep(1, K) * 20
diri_s2 = rep(1, K) * 20
simil_mat = DCATS::create_simMat(K, confuse_rate=0.2)
sim_dat <- DCATS::simulator_base(totals1, totals2, diri_s1, diri_s2, simil_mat)
sim_count = rbind(sim_dat$numb_cond1, sim_dat$numb_cond2)
sim_design = data.frame(condition = c("g1", "g1", "g1", "g1", "g2", "g2", "g2"), 
gender = sample(c("Female", "Male"), 7, replace = TRUE))
## Using 1 factor vs NULL factor testing
dcats_GLM(sim_count, sim_design, similarity_mat = simil_mat)
## Using full factors vs n-1 factors testing with intercept term
dcats_GLM(sim_count, sim_design, similarity_mat = simil_mat, base_model='FULL')
## Fix phi
dcats_GLM(sim_count, sim_design, similarity_mat = simil_mat, fix_phi = 1/61)
## Specify reference cell type
colnames(sim_count) <- c("celltypeA", "celltypeB", "celltypeC")

}
