% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingValuesImputation_ProteinLevel.R
\name{getQuantile4Imp}
\alias{getQuantile4Imp}
\title{Quantile imputation value definition}
\usage{
getQuantile4Imp(qdata, qval = 0.025, factor = 1)
}
\arguments{
\item{qdata}{An expression set containing quantitative values of various
replicates}

\item{qval}{The quantile used to define the imputation value}

\item{factor}{A scaling factor to multiply the imputation value with}
}
\value{
A list of two vectors, respectively containing the imputation values
and the rescaled imputation values
}
\description{
This method returns the q-th quantile of each column of an expression set,
 up to a scaling factor
}
\examples{
data(Exp1_R25_prot, package="DAPARdata")
qdata <- Biobase::exprs(Exp1_R25_prot)
quant <- getQuantile4Imp(qdata)

}
\author{
Thomas Burger
}
