% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots_compare_Norm.R
\name{compareNormalizationD_HC}
\alias{compareNormalizationD_HC}
\title{Builds a plot from a dataframe. Same as compareNormalizationD but
uses the library \code{highcharter}}
\usage{
compareNormalizationD_HC(
  qDataBefore,
  qDataAfter,
  keyId = NULL,
  conds = NULL,
  pal = NULL,
  subset.view = NULL,
  n = 1,
  type = "scatter"
)
}
\arguments{
\item{qDataBefore}{A dataframe that contains quantitative data before
normalization.}

\item{qDataAfter}{A dataframe that contains quantitative data after
normalization.}

\item{keyId}{xxx}

\item{conds}{A vector of the conditions (one condition
per sample).}

\item{pal}{xxx}

\item{subset.view}{xxx}

\item{n}{An integer that is equal to the maximum number of displayed points.
This number must be less or equal to the size
of the dataset. If it is less than it, it is a random selection}

\item{type}{scatter or line}
}
\value{
A plot
}
\description{
Plot to compare the quantitative proteomics data before and after
normalization using the package \code{highcharter}
}
\examples{
data(Exp1_R25_prot, package="DAPARdata")
obj <- Exp1_R25_prot
qDataBefore <- Biobase::exprs(obj)
conds <- Biobase::pData(obj)[, "Condition"]
id <- Biobase::fData(obj)[, 'Protein_IDs']
pal <- ExtendPalette(2)
objAfter <- wrapper.normalizeD(obj,
method = "QuantileCentering",
conds = conds, type = "within conditions"
)

n <- 1
compareNormalizationD_HC(
qDataBefore = qDataBefore,
qDataAfter = Biobase::exprs(objAfter), 
keyId = id, 
pal = pal, 
n = n,
subset.view = seq_len(n),
conds = conds)

}
\author{
Samuel Wieczorek
}
