% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{SetMatAdj}
\alias{SetMatAdj}
\title{Record the adjacency matrices in a slot of the
dataset  of class \code{MSnSet}}
\usage{
SetMatAdj(obj, X)
}
\arguments{
\item{obj}{An object (peptides) of class \code{MSnSet}.}

\item{X}{A list of two adjacency matrices}
}
\value{
NA
}
\description{
Record the adjacency matrices in a slot of the
dataset  of class \code{MSnSet}
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
Xshared <- BuildAdjacencyMatrix(Exp1_R25_pept[seq_len(100)], 
"Protein_group_IDs", FALSE)
Xunique <- BuildAdjacencyMatrix(Exp1_R25_pept[seq_len(100)], 
"Protein_group_IDs", TRUE)
ll.X <- list(matWithSharedPeptides = Xshared, 
matWithUniquePeptides = Xunique)
Exp1_R25_pept <- SetMatAdj(Exp1_R25_pept, ll.X)

}
\author{
Samuel Wieczorek
}
