% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agregation.R
\name{CountPep}
\alias{CountPep}
\title{Compute the number of peptides used to aggregate proteins}
\usage{
CountPep(M)
}
\arguments{
\item{M}{A "valued" adjacency matrix in which lines and columns correspond
respectively to peptides and proteins.}
}
\value{
A vector of boolean which is the adjacency matrix
but with NA values if they exist in the intensity matrix.
}
\description{
This function computes the number of peptides used to aggregate proteins.
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
protID <- "Protein_group_IDs"
M <- BuildAdjacencyMatrix(Exp1_R25_pept[seq_len(10)], protID, FALSE)
CountPep(M)

}
\author{
Alexia Dorffer
}
