% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotSelectedFlowFrame}
\alias{plotSelectedFlowFrame}
\title{Plot a flow frame from a CytoPipeline run}
\usage{
plotSelectedFlowFrame(
  experimentName,
  whichQueue,
  sampleFile,
  flowFrameName,
  path,
  xChannelLabel,
  yChannelLabel,
  useAllCells,
  nDisplayCells,
  useFixedLinearRange,
  linearRange,
  transfoListName = " "
)
}
\arguments{
\item{experimentName}{the experiment name (representing a pipeline run)
from which to extract the flow frame}

\item{whichQueue}{"pre-processing" or "scale transform"}

\item{sampleFile}{in case 'whichQueue' is set to 'pre-processing, which
sample file to look at. This can be a number or a character.
\itemize{
\item if whichQueue == "scale transform", the sampleFile is ignored
\item if NULL and whichQueue == "pre-processing", the sampleFile is defaulted
to the first one belonging to the experiment
}}

\item{flowFrameName}{the name of the object to fetch
(as referenced in the pipeline workflow)}

\item{path}{the root path to look for the CytoPipeline experiment cache}

\item{xChannelLabel}{the label of the channel to be displayed on the x axis:
the conventional syntax is : \code{channelName} + " - " + \code{channelMarker}}

\item{yChannelLabel}{the label of the channel to be displayed on the y axis:
the conventional syntax is : \code{channelName} + " - " + \code{channelMarker}}

\item{useAllCells}{if TRUE, no subsampling will be done}

\item{nDisplayCells}{if useAllCells == FALSE, the number of subsampled cells}

\item{useFixedLinearRange}{if TRUE, all channels using a linear scale will
use a fixed range set by linearRange}

\item{linearRange}{set for all channels using a linear scale,
if useFixedLinearRange == TRUE}

\item{transfoListName}{if not set to " ", the transformation list
(as an object name ending with "_obj", as referenced in the pipeline
workflow) to be used for for display.}
}
\value{
a ggplot object
}
\description{
Based on an experiment name, this function will gather the
required flowFrame from the CytoPipeline disk cache and display it using
the user chosen 1D or 2D view.
}
\examples{

# run CytoPipeline object first

outputDir <- base::tempdir()


rawDataDir <-
    system.file("extdata", package = "CytoPipeline")
experimentName <- "OMIP021_PeacoQC"
sampleFiles <- 
    file.path(
        rawDataDir, 
        list.files(rawDataDir, pattern = "Donor"))
jsonDir <- system.file("extdata", package = "CytoPipeline")
jsonPath <- file.path(jsonDir, "pipelineParams.json")

pipL2 <- CytoPipeline(
    jsonPath,
    experimentName = experimentName,
    sampleFiles = sampleFiles)

suppressWarnings(execute(
    pipL2,
    rmCache = TRUE,
    path = outputDir))

plotSelectedFlowFrame(
    experimentName = experimentName,
    whichQueue = "pre-processing",
    sampleFile = 1,
    flowFrameName = "remove_debris_obj",
    path = outputDir,
    xChannelLabel = "FSC-A : NA",
    yChannelLabel = "SSC-A : NA",
    useAllCells = TRUE,
    nDisplayCells = 0,
    useFixedLinearRange = TRUE,
    linearRange = c(-100, 262144))

plotSelectedFlowFrame(
    experimentName = experimentName,
    whichQueue = "pre-processing",
    sampleFile = 1,
    flowFrameName = "remove_debris_obj",
    path = outputDir,
    xChannelLabel = "FSC-A : NA",
    yChannelLabel = "SSC-A : NA",
    useAllCells = FALSE,
    nDisplayCells = 100,
    useFixedLinearRange = FALSE,
    linearRange = NULL)

plotSelectedFlowFrame(
    experimentName = experimentName,
    whichQueue = "pre-processing",
    sampleFile = 1,
    flowFrameName = "remove_debris_obj",
    path = outputDir,
    xChannelLabel = "Comp-670/30Violet-A : BV785 - CD3",
    yChannelLabel = "Comp-780/60Red-A : APCCy7 - CD4",
    useAllCells = TRUE,
    nDisplayCells = 0,
    useFixedLinearRange = FALSE,
    linearRange = NULL,
    transfoListName = "scale_transform_estimate_obj")

}
