# CytoPipelineGUI - Copyright (C) <2022-2025>
# <Université catholique de Louvain (UCLouvain), Belgique>
#
#   Description and complete License: see LICENSE file.
#
# This program (CytoPipelineGUI) is free software:
#   you can redistribute it and/or modify it under the terms of the GNU General
# Public License as published by the Free Software Foundation,
# either version 3 of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details (<http://www.gnu.org/licenses/>).

#' @title CytoPipelineGUI package
#' 
#' @name CytoPipelineGUI
#'
#' @rdname CytoPipelineGUI
#' 
#' @seealso \link[CytoPipeline:CytoPipeline-package]{CytoPipeline}
#' @seealso [CytoPipelineGUI::CytoPipelineCheckApp] 
#' @seealso [CytoPipelineGUI::ScaleTransformApp]
#'
#' @description
#'
#' `CytoPipelineGUI` is the companion package of `CytoPipeline`, 
#' and is used for interactive visualization. 
#' It implements two shiny applications :
#' - a shiny app for interactive comparison of flow frames 
#'   that are the results of CytoProcessingSteps of the same 
#'   or different CytoPipeline experiments.  
#' It is launched using the following statement: `CytoPipelineCheckApp()`  
#' - a shiny app for interactive visualization and manual adjustments of scale 
#'   transformation objects. It is launched using the following statement: 
#'   `ScaleTransformApp()` 
#'   
#' @keywords internal
"_PACKAGE"

## usethis namespace: start
## usethis namespace: end
NULL
