% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.cytoglm.R
\name{print.cytoglm}
\alias{print.cytoglm}
\title{Extact and print bootstrap GLM fit}
\usage{
\method{print}{cytoglm}(x, ...)
}
\arguments{
\item{x}{A \code{cytoglm} class}

\item{...}{Other parameters}
}
\value{
NULL.
}
\description{
Extact and print bootstrap GLM fit
}
\examples{
set.seed(23)
df <- generate_data()
protein_names <- names(df)[3:12]
df <- dplyr::mutate_at(df, protein_names, function(x) asinh(x/5))
glm_fit <- CytoGLMM::cytoglm(df,
                             protein_names = protein_names,
                             condition = "condition",
                             group = "donor",
                             num_boot = 10) # in practice >=1000
print(glm_fit)
}
