% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev.R
\name{hdf5_to_anndata}
\alias{hdf5_to_anndata}
\title{Converts a series of HDF5Array-serialized SingleCellExperiments to AnnData}
\usage{
hdf5_to_anndata(input_directory, output_directory)
}
\arguments{
\item{input_directory}{A character scalar. The path to a directory containing one or more
directories created by \code{\link[HDF5Array:saveHDF5SummarizedExperiment]{HDF5Array::saveHDF5SummarizedExperiment()}}.}

\item{output_directory}{A character scalar. The path to a directory in which to save the
created anndata files.}
}
\value{
A character vector of the newly-created anndata files
}
\description{
Converts a series of HDF5Array-serialized SingleCellExperiments to AnnData
}
\examples{
\donttest{
hdf5_to_anndata(
    "/vast/projects/cellxgene_curated/splitted_DB2_data_0.2.1",
    "/vast/projects/cellxgene_curated/splitted_DB2_anndata_0.2.1"
)
hdf5_to_anndata(
    "/vast/projects/cellxgene_curated/splitted_DB2_data_scaled_0.2.1",
    "/vast/projects/cellxgene_curated/splitted_DB2_anndata_scaled_0.2.1"
)
}
}
\keyword{internal}
