% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeAssays-method.R
\name{mergeAssays,LongTable-method}
\alias{mergeAssays,LongTable-method}
\title{Endomorphically merge assays within a \code{LongTable} or inheriting class}
\usage{
\S4method{mergeAssays}{LongTable}(object, x, y, target = x, ..., metadata = FALSE)
}
\arguments{
\item{object}{A \code{LongTable} or inheriting class.}

\item{x}{\code{character(1)} A valid assay name in \code{object}.}

\item{y}{\code{character(1)} A valid assay name in \code{object}.}

\item{target}{\code{character(1)} Name of the assay to assign the result to.
Can be a new or existing assay. Defaults to \code{x}.}

\item{...}{Fallthrough arguments to merge.data.table to specify the join
type. Use this to specify which columns to merge on. If excluded, defaults
to by=assayKeys(objecty, y).}

\item{metadata}{\code{logical} A logical vector indicating whether to attach
metadata to either assay before the merge occurs. If only one value is
passed that value is used for both assays. Defaults to \code{FALSE}.}
}
\value{
A copy of \code{object} with assays \code{x} and \code{y} merged and assigned to
\code{target}.
}
\description{
Endomorphically merge assays within a \code{LongTable} or inheriting class
}
\seealso{
\code{\link{merge.data.table}}
}
\author{
Christopher Eeles
}
