% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CellStateMethods.R
\name{CellClusterProbabilityDistribution}
\alias{CellClusterProbabilityDistribution}
\alias{CellClusterProbabilityDistribution.SingleCellExperiment}
\alias{CellClusterProbabilityDistribution,SingleCellExperiment-method}
\title{Cell cluster probability distribution}
\usage{
CellClusterProbabilityDistribution.SingleCellExperiment(
  object,
  label,
  group,
  probability
)

\S4method{CellClusterProbabilityDistribution}{SingleCellExperiment}(
  object,
  label,
  group,
  probability = "scaled_mean_probs"
)
}
\arguments{
\item{object}{An object of \code{SingleCellExperiment} class with aggregated
cell cluster probability available in \code{colData(object)}, which can be
obtained after running \code{SummariseCellClusterProbability()}.}

\item{label}{Character specifying the \code{colData} variable to use as cell
type/cluster label.}

\item{group}{Character specifying the \code{colData} variable to use as
categorical group variable.}

\item{probability}{Character specifying the aggregated cell cluster probability
variable available in \code{colData}, used to plot its distribution. One of
\code{"mean_probs"}, \code{"scaled_mean_probs"}, \code{"median_probs"},
\code{"scaled_median_probs"}. The availability of these variables in \code{colData}
depends on the parameters given to the function \code{SummariseCellClusterProbability()}
beforehand. By default assumes that \code{"scaled_mean_probs"} is available in
\code{colData}, which is only true if \code{SummariseCellClusterProbability()}
function was run with \code{funs = "mean"} and \code{scale.funs = TRUE}.}
}
\value{
A plot of class \code{ggplot}.
}
\description{
Plot cell cluster probability distribution per label by group.
}
\examples{
# Import package
suppressPackageStartupMessages(library("SingleCellExperiment"))

# Create toy SCE data
batches <- c("b1", "b2")
set.seed(239)
batch <- sample(x = batches, size = nrow(iris), replace = TRUE)
sce <- SingleCellExperiment(
    assays = list(logcounts = t(iris[, 1:4])),
    colData = DataFrame(
        "Species" = iris$Species,
        "Batch" = batch
    )
)
colnames(sce) <- paste0("samp", 1:ncol(sce))

# Prepare SCE object for analysis
sce <- PrepareData(sce)

# Multi-level integration (just for highlighting purposes; use default parameters)
set.seed(123)
sce <- RunParallelDivisiveICP(
    object = sce, batch.label = "Batch",
    k = 4, L = 25, C = 1, d = 0.5,
    train.with.bnn = FALSE,
    use.cluster.seed = FALSE,
    build.train.set = FALSE, ari.cutoff = 0.1,
    threads = 2, RNGseed = 1024
)

# Summarise cell cluster probability
sce <- SummariseCellClusterProbability(object = sce, icp.round = 2) # saved in 'colData'

# Search for differences in probabilities across group(s)
# give an interesting variable to the "group" parameter
prob.dist <- CellClusterProbabilityDistribution(
    object = sce, label = "Species",
    group = "Batch",
    probability = "scaled_mean_probs"
)
prob.dist # print plot

}
\keyword{Distribution}
\keyword{cell}
\keyword{cluster}
\keyword{probability}
