% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proteinPlot.R
\name{proteinPlot}
\alias{proteinPlot}
\title{Create Line Plots}
\usage{
proteinPlot(
  dataFrame,
  protein,
  max_frac,
  grid = TRUE,
  titleLabel = "all",
  titleAlign = "left",
  ylabel = "Relative Protein Abundance",
  xlabel = "Fraction",
  legendLabel = "Condition",
  labelled = "Labeled",
  unlabelled = "Unlabeled",
  controlSample = "",
  textSize = 12,
  axisTextSize = 8
)
}
\arguments{
\item{dataFrame}{data frame, contains columns: `Protein Group Accessions` 
character; `Protein Descriptions` character;bFraction integer;
isLabel character ("TRUE"/"FALSE" values);`Precursor Area` double;
scenario character}

\item{protein}{character the protein of interest}

\item{max_frac}{integer total number of fractions}

\item{grid}{logical specifies presence/absence of gridline in the plot}

\item{titleLabel}{character, if it is 'all' or 'GN', it specifies whether to 
show full label or just the gene name, if any other character is used, the
value of titleLabel will be used as plot title}

\item{titleAlign}{character one of the 'left', 'center'/'centre', 'right',
specifies alignment of the title in plot}

\item{ylabel}{character}

\item{xlabel}{character}

\item{legendLabel}{character}

\item{labelled}{character label to be used for isLabel == TRUE}

\item{unlabelled}{character label to be used for isLabel == FALSE}

\item{controlSample}{character, either labelled or unlabelled, this setting
will adjust plot coloring based on which sample is a control}

\item{textSize}{numeric, size of text in the plot}

\item{axisTextSize}{numeric, size of axis labels in the plot}
}
\value{
a plot
}
\description{
This function creates a line plot for a proteins in dataFrame specified
by protein
}
\examples{

##Use example normalised proteins file
inputFile <- system.file("extData", "dataNormProts.txt", package = "ComPrAn")
#read file in and change structure of table to required format
forAnalysis <- protImportForAnalysis(inputFile)
##example plot:
protein <- "P52815"
max_frac <- 23
proteinPlot(forAnalysis, protein, max_frac)

}
