% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustAll_ClustAllObject_Class.R
\name{summary_clusters}
\alias{summary_clusters}
\alias{summary_clusters,ClustAllObject-method}
\title{Retrieve Summary of Clustering Results from ClustAllObject}
\usage{
summary_clusters(Object)
}
\arguments{
\item{Object}{A processed \code{\link{ClustAllObject-class}} object. The object
must have been processed by \code{\link{runClustAll}} before using this method.}
}
\value{
A list where each element represents a stratification. Each stratification
is a vector of cluster assignments for each sample in the dataset. Returns NULL
if \code{\link{runClustAll}} has not been executed on the object.
}
\description{
This method extracts and returns a comprehensive summary of all clustering
results (stratifications) generated by the ClustALL algorithm. It provides
access to the complete set of clustering solutions, including both robust
and non-robust stratifications.
}
\details{
The summary_clusters method provides access to all clustering results generated
during the ClustALL analysis:

\enumerate{
  \item Comprehensive Results:
  \itemize{
    \item Includes all stratifications generated, regardless of their robustness.
    \item Each stratification represents a unique combination of data embedding,
          distance metric, clustering algorithm, and number of clusters.
  }

  \item Stratification Structure:
  \itemize{
    \item Each element in the returned list is named according to the parameters
          used to generate it (e.g., "cuts_a_1" for the first cut using method 'a').
    \item Each stratification is a vector of integers, where each integer represents
          a cluster assignment for a sample.
  }

  \item Analysis Possibilities:
  \itemize{
    \item Allows for comparison of different clustering solutions.
    \item Enables examination of how different algorithm parameters affect clustering outcomes.
    \item Facilitates identification of consistent patterns across multiple stratifications.
  }
}

This method is particularly useful for:
\itemize{
  \item Accessing the full range of clustering solutions for in-depth analysis.
  \item Comparing robust stratifications (identified by other methods) with the full set of results.
  \item Extracting specific stratifications for further analysis or visualization.
}
}
\note{
\itemize{
  \item This method returns the data stored in the 'summary_clusters' slot of the ClustAllObject.
  \item It will return NULL if \code{\link{runClustAll}} has not been executed on the object.
  \item The returned list includes all stratifications, not just those deemed robust.
    For accessing only robust stratifications, consider using the \code{\link{resStratification}} function.
  \item The order and naming of stratifications in the returned list correspond to
    the order in which they were generated during the ClustALL process.
}
}
\examples{
data("BreastCancerWisconsin", package = "ClustAll")
wdbc <- subset(wdbc,select=c(-ID, -Diagnosis))
wdbc <- wdbc[1:15,1:8]
obj_noNA <- createClustAll(data = wdbc)
obj_noNA1 <- runClustAll(Object = obj_noNA, threads = 1, simplify = FALSE)
summary_clusters(obj_noNA1)
}
\seealso{
\code{\link{runClustAll}}, \code{\link{resStratification}},
\code{\link{JACCARD_DISTANCE_F}}, \code{\link{ClustAllObject-class}}
}
