% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustAll_runClustAll.R
\name{runClustAll}
\alias{runClustAll}
\alias{runClustAll,ClustAllObject,numericOrNA,logicalOrNA-method}
\title{Execute ClustALL Algorithm on a ClustAllObject}
\usage{
runClustAll(Object, threads = 1, simplify = FALSE)
}
\arguments{
\item{Object}{An unprocessed \code{\link{ClustAllObject-class}} created by
\code{\link{createClustAll}}. The object should contain the original input
data and any preprocessed versions of it, but no stratification results yet.}

\item{threads}{An integer specifying the number of CPU cores to use for
parallel computing. Default is 1 (single-core processing).}

\item{simplify}{A logical value. If TRUE, only every fourth depth of the
dendrogram will be considered in the DCR and SP steps, reducing execution
time but potentially sacrificing detail. Default is FALSE.}
}
\value{
A processed \code{\link{ClustAllObject-class}} containing
stratification results from the ClustALL pipeline. The object's
summary_clusters and JACCARD_DISTANCE_F slots will be populated with results.
}
\description{
This function applies the ClustALL algorithm to the data stored in a
ClustAllObject. It performs a comprehensive analysis, generating multiple
patient stratifications based on various clustering methods and parameters.
The function implements the core steps of the ClustALL framework: Data
Complexity Reduction (DCR), Stratification Process (SP), and Consensus-based
Stratifications (CbS).
}
\details{
The runClustAll function implements the three main steps of the ClustALL
framework:

\enumerate{
  \item Data Complexity Reduction (DCR):
  \itemize{
    \item Creates multiple data embeddings to replace highly correlated variable
      sets with lower-dimension projections derived from Principal Component
      Analysis (PCA).
    \item Explores all relevant groupings derived from a hierarchical
      clustering-based dendrogram.
    \item Computes an embedding for each depth in the dendrogram.
  }

  \item Stratification Process (SP):
  \itemize{
    \item Calculates and preliminarily evaluates stratifications for each embedding.
    \item Computes a stratification for each feasible combination of embedding,
      dissimilarity metric, and clustering method.
    \item Determines the optimal number of clusters using three internal validation
      measures: sum-of-squares (WB-ratio), Dunn index, and average silhouette width.
  }

  \item Consensus-based Stratifications (CbS):
  \itemize{
    \item Filters out non-robust stratifications through bootstrapping.
    \item Excludes stratifications with less than 85% stability.
    \item Selects representatives of very similar outcomes from the remaining
      stratifications.
  }
}

The 'simplify' parameter, when set to TRUE, reduces computation time by
considering only every fourth depth of the dendrogram in the first and second
steps. While useful for preliminary results, it's recommended to set it to
FALSE for more robust and detailed results.
}
\note{
\itemize{
  \item This function modifies the input ClustAllObject in-place, populating it with
    stratification results.
  \item The process can be computationally intensive,
    especially for large datasets or when 'simplify' is set to FALSE.
  \item Consider using multiple threads for improved performance on multi-core systems.
}
}
\examples{
data("BreastCancerWisconsin", package = "ClustAll")
wdbc <- subset(wdbc,select=c(-ID, -Diagnosis))
wdbc <- wdbc[1:15,1:8]
\donttest{
obj_noNA <- createClustAll(data = wdbc)
obj_noNA1 <- runClustAll(Object = obj_noNA, threads = 1, simplify = TRUE)
obj_noNA1
}
}
\seealso{
\code{\link{createClustAll}}, \code{\link{resStratification}},
\code{\link{plotJACCARD}}, \code{\link{cluster2data}},
\code{\link{ClustAllObject-class}}
}
