% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustAll_ClustAllObject_Class.R
\name{dataImputed}
\alias{dataImputed}
\alias{dataImputed,ClustAllObject-method}
\title{Retrieve Imputed Data from ClustAllObject}
\usage{
dataImputed(Object)
}
\arguments{
\item{Object}{A \code{\link{ClustAllObject-class}} object created by
\code{\link{createClustAll}}.}
}
\value{
A 'mids' object from the mice package containing the imputed datasets.
If no imputation was performed, the method returns NULL.
}
\description{
This method extracts and returns the imputed datasets stored in a ClustAllObject.
It provides access to the multiple imputed versions of the data generated to
handle missing values, if imputation was conducted and included in the object.
}
\details{
The dataImputed method provides access to the imputed data used in the ClustALL
analysis pipeline when missing values are present. Key aspects of this data include:

\enumerate{
  \item Imputation Structure:
  \itemize{
    \item Returns a 'mids' object, which contains multiple imputed datasets.
    \item Each imputed dataset is a complete version of the original data with
          missing values filled in.
    \item The number of imputed datasets corresponds to the 'nImputation' parameter.
  }

  \item Imputation Method:
  \itemize{
    \item Imputation is performed using the mice (Multivariate Imputation by Chained
          Equations) package.
    \item The specific imputation methods used for each variable can be examined
          in the returned 'mids' object.
  }

  \item Data Consistency:
  \itemize{
    \item The imputed datasets maintain the same structure (rows and columns) as
          the original data.
    \item Only variables with missing values are imputed; complete variables remain unchanged.
  }
}#'
}
\examples{
data("BreastCancerWisconsinMISSING", package = "ClustAll")
data("BreastCancerWisconsin", package = "ClustAll")
wdbc <- subset(wdbc,select=-ID)
obj_NA <- createClustAll(data = wdbcNA, colValidation = "Diagnosis",
                         dataImputed = wdbcMIDS)
dataImputed(obj_NA)
}
\seealso{
\code{\link{createClustAll}}, \code{\link{showData}},
\code{\link{dataOriginal}}, \code{\link{ClustAllObject-class}},
}
