% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{summarize_reads}
\alias{summarize_reads}
\title{Summarize reads for different genomic features}
\usage{
summarize_reads(
  SummarizedCounts = NULL,
  isPairedEnd = TRUE,
  allowMultiOverlap = FALSE,
  countMultiMappingReads = TRUE,
  fraction = TRUE,
  minMQS = 0,
  saf_list = NULL,
  gtf = NULL,
  threads = 1,
  verbose = FALSE
)
}
\arguments{
\item{SummarizedCounts}{An object of \link{SummarizedCounts}.}

\item{isPairedEnd}{A logical(1), whether the RNA-seq data is paired-end.}

\item{allowMultiOverlap}{A logical(1), indicating if a read is allowed to be
assigned to more than one feature (or meta-feature) if it is found to
overlap with more than one feature (or meta-feature). FALSE by default. A
read (or read pair) will be assigned to the feature (or meta-feature) that
has the largest number of overlapping bases, if the read (or read pair)
overlaps with multiple features (or meta-features).}

\item{countMultiMappingReads}{A logical(1), indicating if multi-mapping
reads/fragments should be counted, TRUE by default. ‘NH’ tag is used to
located multi-mapping reads in the input BAM/SAM files.}

\item{fraction}{A logical(1) indicating if fractional counts are produced for
multi-mapping reads and/or multi-overlapping reads. FALSE by default.}

\item{minMQS}{An integer(1), giving the minimum mapping quality score a read
must satisfy in order to be counted. For paired-end reads, at least one end
should satisfy this criteria. 0 by default.}

\item{saf_list}{A list of data frames containing annotation in the SAF
format, such as the output of the \code{\link[=get_saf]{get_saf()}} function.}

\item{gtf}{A character(1), specifying a path to a GTF file.}

\item{threads}{An integer(1), number of threads for
\code{\link[Rsubread:featureCounts]{Rsubread::featureCounts()}} calling.}

\item{verbose}{A logical(1) vector, indicating if verbose information for
debugging will be generated. This may include information such as unmatched
chromosomes/contigs between reads and annotation.}
}
\value{
An object of \link{SummarizedCounts} with the feature_counts field
populated by modified output from the \code{\link[Rsubread:featureCounts]{Rsubread::featureCounts()}}
function for each type of genomic features.
}
\description{
Summarize reads in alignment files, SAM or BAM, to different genomic regions,
such as genic regions, intergenic regions, exonic regions, intronic regions,
rRNA genes, mitochrondrial genome, chloroplast genome (only for plants), and
gene-level exonic regions using \code{\link[Rsubread:featureCounts]{Rsubread::featureCounts()}}.
}
\examples{
\dontshow{if (require("R.utils") && require("ensembldb")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
tmp_dir <- tempdir()
in_dir <- system.file("extdata", package = "CleanUpRNAseq")
gtf.gz <- dir(in_dir, ".gtf.gz$", full.name = TRUE)
gtf <- file.path(tmp_dir, gsub("\\\\.gz", "", basename(gtf.gz)))
R.utils::gunzip(gtf.gz, destname= gtf,
                overwrite = TRUE, remove = FALSE)

in_dir <- system.file("extdata", package = "CleanUpRNAseq")
BAM_file <- dir(in_dir, ".bam$", full.name = TRUE)
salmon_quant_file <- dir(in_dir, ".sf$", full.name = TRUE)
sample_name = gsub(".+/(.+?).srt.bam", "\\\\1", BAM_file)
salmon_quant_file_opposite_strand <- salmon_quant_file
col_data <- data.frame(sample_name = sample_name,
                       BAM_file = BAM_file,
                       salmon_quant_file = salmon_quant_file,
                       salmon_quant_file_opposite_strand =
                           salmon_quant_file_opposite_strand,
                       group = c("CD1N", "CD1P"))

sc <- create_summarizedcounts(lib_strand = 0, colData = col_data)

bam_file <- system.file("extdata", "K084CD7PCD1N.srt.bam",
    package = "CleanUpRNAseq"
)

tmp_dir <- tempdir()
gtf <- system.file("extdata", "example.gtf.gz",
                   package = "CleanUpRNAseq")
hs_ensdb_sqlite <-
    ensembldb::ensDbFromGtf(
        gtf = gtf,
        outfile = file.path(tmp_dir, "EnsDb.hs.v110.sqlite"),
        organism = "Homo_Sapiens",
        genomeVersion = "GRCh38",
        version = 110
    )
saf_list <- get_saf(
    ensdb_sqlite = hs_ensdb_sqlite,
    bamfile = bam_file,
    mitochondrial_genome = "MT"
)

counts_list <- summarize_reads(
    SummarizedCounts = sc,
    saf_list = saf_list,
    gtf = gtf
)

\dontshow{\}) # examplesIf}
}
