% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{salmon_tximport}
\alias{salmon_tximport}
\title{Import Salmon quantification output into R}
\usage{
salmon_tximport(
  SummarizedCounts = NULL,
  ensdb_sqlite = NULL,
  filtered_gene_biotypes = c("artifact", "TEC", "miRNA", "tRNA", "misc_RNA", "Mt_rRNA",
    "Mt_tRNA", "rRNA", "rRNA_pseudogene", "scaRNA", "scRNA", "snoRNA", "snRNA", "sRNA",
    "vault_RNA", "TR_V_pseudogene", "IG_C_pseudogene", "IG_J_pseudogene",
    "IG_V_pseudogene", "IG_pseudogene", "TR_J_pseudogene", "TR_V_pseudogene")
)
}
\arguments{
\item{SummarizedCounts}{An object of \link{SummarizedCounts}.}

\item{ensdb_sqlite}{An object of the \link[ensembldb:EnsDb-class]{ensembldb::EnsDb} or a
character(1) vector, specifying a path to an SQLite database for an
object of the \link[ensembldb:EnsDb-class]{ensembldb::EnsDb}.}

\item{filtered_gene_biotypes}{A character(n) vector,specifying the biotypes
of genes which will not be considered for downstream gene expression
analysis. By default, genes of the following biotypes are excluded:
"artifact","TEC","miRNA","tRNA", "misc_RNA", "Mt_rRNA", "Mt_tRNA", "rRNA",
"rRNA_pseudogene", "scaRNA", "scRNA", "snoRNA", "snRNA", "sRNA",
"vault_RNA", "TR_V_pseudogene", "IG_C_pseudogene", "IG_J_pseudogene",
"IG_V_pseudogene", "IG_pseudogene", "TR_J_pseudogene", "TR_V_pseudogene",
because their transcripts are too short (< 200 nt) or not likely expressed
at all.}
}
\value{
An object of \link{SummarizedCounts} with the feature_counts field
populated by a list of of matrices of gene-level abundance, counts, and
length outputted by \code{\link[tximport:tximport]{tximport::tximport()}}, as described in the folowing:
\describe{
\item{abundance}{A numeric matrix containing abundance (TPM) for each gene
of each sample}
\item{counts}{A numeric matrix containing read count (fraction) for each
gene of each sample}
\item{length}{A numeric matrix containing length (bp) for each gene of
each sample}
}
}
\description{
Import Salmon quantification output into R using tximport
}
\examples{
require("ensembldb")
in_dir <- system.file("extdata", package = "CleanUpRNAseq")
BAM_file <- dir(in_dir, ".bam$", full.name = TRUE)
salmon_quant_file <- dir(in_dir, ".sf$", full.name = TRUE)
sample_name = gsub(".+/(.+?).srt.bam", "\\\\1", BAM_file)
salmon_quant_file_opposite_strand <- salmon_quant_file
col_data <- data.frame(sample_name = sample_name,
                       BAM_file = BAM_file,
                       salmon_quant_file = salmon_quant_file,
                       salmon_quant_file_opposite_strand =
                           salmon_quant_file_opposite_strand,
                       group = c("CD1N", "CD1P"))

sc <- create_summarizedcounts(lib_strand = 0, colData = col_data)

tmp_dir <- tempdir()
gtf <- system.file("extdata", "example.gtf.gz",
                   package = "CleanUpRNAseq")
hs_ensdb_sqlite <-
    ensembldb::ensDbFromGtf(
        gtf = gtf,
        outfile = file.path(tmp_dir, "EnsDb.hs.v110.sqlite"),
        organism = "Homo_Sapiens",
        genomeVersion = "GRCh38",
        version = 110
    )
salmon_counts <- salmon_tximport(
    SummarizedCounts = sc,
    ensdb_sqlite = hs_ensdb_sqlite
)

}
