% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_gDNA.R
\name{plot_gene_content}
\alias{plot_gene_content}
\title{Check the percentage of genes with counts greater than minimal CPM}
\usage{
plot_gene_content(SummarizedCounts = NULL, min_cpm = 1, min_tpm = 1)
}
\arguments{
\item{SummarizedCounts}{An object of \link{SummarizedCounts}..}

\item{min_cpm}{A numeric(1), minimal CPM threshold.}

\item{min_tpm}{A numeric(1), minimal TPM threshold.}
}
\value{
A ggplot object if \code{counts} is not \code{NULL}, showing percentages of
genes with counts above the user-specified minimal CPM (count per million)
in each sample. Or a ggplot object of two panels if both \code{counts} and
\code{abundance} are not \code{NULL}, showing percentages of genes  with counts
above the user-specified minimal CPM and minimal TPM (transcript per
million) in each sample.

A ggplot object.
}
\description{
Check the percentage of genes with counts greater than minimal CPM
}
\details{
The axis title contains unicode, so please output the plot in the svg format
using the svglite package, instead of \code{\link[grDevices:pdf]{grDevices::pdf()}}, for high-
resolution plot.
}
\examples{
lib_strand <- 0
col_data_f <- system.file("extdata", "example.colData.txt",
                         package = "CleanUpRNAseq")
col_data <- read.delim(col_data_f, as.is = TRUE)
## create fake bam files
tmp_dir <- tempdir()
bamfiles <- gsub(".+/", "", col_data$BAM_file)
null <- lapply(file.path(tmp_dir, bamfiles), file.create)
## create fake quant.sf files
quant_sf <- file.path(tmp_dir, gsub(".srt.bam$",
                                    "quant.sf",
                                    bamfiles))
null <- lapply(quant_sf, file.create)
col_data$BAM_file <- file.path(tmp_dir, bamfiles)
col_data$salmon_quant_file <- quant_sf

## pretend this is stranded RA=NA-seq data
col_data$salmon_quant_file_opposite_strand <- quant_sf

sc <- create_summarizedcounts(lib_strand, col_data)

data("feature_counts_list")
data("salmon_quant")

sc$set_feature_counts(feature_counts_list)
sc$set_salmon_quant(salmon_quant)
sc$set_salmon_quant_opposite(salmon_quant)
plot_gene_content(
    SummarizedCounts = sc,
    min_cpm = 1,
    min_tpm =1
)

}
