% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precisionPathways.R
\name{calcCostsAndPerformance}
\alias{calcCostsAndPerformance}
\alias{summary.PrecisionPathways}
\alias{bubblePlot}
\alias{bubblePlot.PrecisionPathways}
\alias{flowchart}
\alias{flowchart.PrecisionPathways}
\alias{strataPlot}
\alias{strataPlot.PrecisionPathways}
\title{Various Functions for Evaluating Precision Pathways}
\usage{
calcCostsAndPerformance(precisionPathways, costs = NULL)

\method{summary}{PrecisionPathways}(object, weights = c(accuracy = 0.5, cost = 0.5), ...)

bubblePlot(precisionPathways, ...)

\method{bubblePlot}{PrecisionPathways}(precisionPathways, pathwayColours = NULL, ...)

flowchart(precisionPathways, ...)

\method{flowchart}{PrecisionPathways}(
  precisionPathways,
  pathway,
  orientation = c("horizontal", "vertical"),
  nodeColours = c(assay = "snow3", class1 = "#3F48CC", class2 = "#880015"),
  ...
)

strataPlot(precisionPathways, ...)

\method{strataPlot}{PrecisionPathways}(
  precisionPathways,
  pathway,
  classColours = c(class1 = "#3F48CC", class2 = "#880015"),
  ...
)
}
\arguments{
\item{precisionPathways}{A pathway of class \code{PrecisionPathways}.}

\item{costs}{A named vector of assays with the cost of each one.}

\item{object}{A set of pathways of class \code{PrecisionPathways}.}

\item{weights}{A numeric vector of length two specifying how to weight the predictive accuracy
and the cost during ranking. Must sum to 1.}

\item{...}{Not used but just following the S3 requirement of the generic template.}

\item{pathwayColours}{A named vector of colours with names being the names of pathways. If none is specified,
a default colour scheme will automatically be chosen.}

\item{pathway}{A character vector of length 1 specifying which pathway to plot, e.g. "clinical-mRNA".}

\item{orientation}{Default: \code{"horizontal"}. Either \code{"horizontal"} or \code{"vertical"}. Specifies the layout of the flowchart.}

\item{nodeColours}{A named vector of colours with names being \code{"assay"}, \code{"class1"},\code{"class2"}.
a default colour scheme will automatically be chosen.}

\item{classColours}{A named vector of colours with names being \code{"class1"},\code{"class2"}, and \code{"accuracy"}.
a default colour scheme will automatically be chosen.}
}
\description{
These functions tabulate or plot various aspects of precision pathways, such as accuracies and costs.
}
