% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{PredictParams}
\alias{PredictParams}
\alias{PredictParams-class}
\alias{PredictParams,missing-method}
\alias{PredictParams,characterOrFunction-method}
\alias{show,PredictParams-method}
\title{Parameters for Classifier Prediction}
\description{
Collects the function to be used for making predictions and any associated
parameters.
}
\details{
The function specified must return either a factor vector of class
predictions, or a numeric vector of scores for the second class, according
to the levels of the class vector of the input data set, or a data frame
which has two columns named class and score.
}
\section{Constructor}{
 
\describe{
\item{\code{PredictParams(predictor, characteristics = DataFrame(), intermediate = character(0), ...)}}{
Creates a PredictParams object which stores the function
which will do the class prediction, if required, and parameters that the
function will use. If the training function also makes predictions, this
must be set to \code{NULL}.}
\describe{ \item{\code{predictor}}{A character keyword referring to a registered classifier. See \code{\link{available}}
for valid keywords.}
\item{\code{characteristics}}{A \code{\link{DataFrame}} describing
the characteristics of the predictor function used. First column must be
named \code{"charateristic"} and second column must be named \code{"value"}.}
\item{\code{intermediate}}{Character vector. Names of any
variables created in prior stages in \code{\link{runTest}} that need to be
passed to the prediction function.}
\item{\code{...}}{Other arguments that \code{predictor} may use.} } }
}

\section{Summary}{

\describe{
\item{\code{predictParams} is a \code{PredictParams} object.}{
  \code{show(predictParams)}: Prints a short summary of what \code{predictParams} contains.
}}
}

\examples{

# For prediction by trained object created by DLDA training function.
predictParams <- PredictParams("DLDA")

}
\author{
Dario Strbenac
}
