% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QCfunctions.R
\name{normaliseExprs}
\alias{normaliseExprs}
\title{normaliseExprs}
\usage{
normaliseExprs(
  sce,
  altExp_name = NULL,
  exprs_value = "counts",
  transform = c("log", "clr", "zi_minMax", "minMax"),
  log_offset = NULL
)
}
\arguments{
\item{sce}{A \code{SingleCellExperiment} object}

\item{altExp_name}{Name of alternative expression
that will be used to perform normalisation}

\item{exprs_value}{A character indicates
which expression value in assayNames is used.}

\item{transform}{type of transformation,
either log or clr (Centered log ratio transform)}

\item{log_offset}{Numeric scalar specifying the pseudo-count
to add when log-transforming expression values. Default is 1}
}
\value{
a SingleCellExperiment object
}
\description{
A function that perform normalisation for alternative expression
}
\examples{
data(CITEseq_example, package = "CiteFuse")
sce_citeseq <- preprocessing(CITEseq_example)
sce_citeseq <- normaliseExprs(sce = sce_citeseq,
altExp_name = "ADT",
transform = "log")
}
