% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{CircSeqAlignTkAlign-class}
\alias{CircSeqAlignTkAlign-class}
\title{Class to store alignment results}
\description{
A class to store alignment results,
including the paths to FASTQ and BAM format files and the alignment summary.
The object belongs to this class
is generated by \code{\link{align_reads}} function.
}
\section{Slots}{

\describe{
\item{\code{input_fastq}}{A path to the query FASTQ format file.}

\item{\code{fastq}}{A vector containing the paths to the two FASTQ format files
used for alignment to the type 1 and type 2 references,
respectively. See \code{\link{align_reads}} for
how the FASTQ format files are generated.}

\item{\code{bam}}{A vector containing the paths to the two BAM format files
corresponding to the alignment results of the two FASTQ files
shown in the \code{fastq} slot, respectively.}

\item{\code{clean_bam}}{A vector containing the paths to the two BAM format files
after filtering by number of mismatch
from BAM format files shown in \code{bam} slot.}

\item{\code{stats}}{A data frame containing alignment summary,
e.g., number of query reads, aligned reads, and unaligned reads.}

\item{\code{reference}}{A \code{\link{CircSeqAlignTkRefIndex-class}}
storing the information of reference for alignment.}
}}

\seealso{
\code{\link{CircSeqAlignTkRefIndex-class}}, \code{\link{align_reads}}
}
